%* lsaf_gettlftemplateid                                                                           *;                                                                                                                                                                                                                                       
%*                                                                                                 *;                                                                                                                                                                                                                                       
%* Gets the alphanumeric id for a Titles, Listings, and Figures (TLF) template.                    *;
%*                                                                                                 *;                                                                                                                                                                                                                                       
%* macrotype LSAF                                                                                  *;                                                                                                                                                                                                                                       
%* since 2.5                                                                                       *;                                                                                                                                                                                                                                       
%* exposure external                                                                               *;                                                                                                                                                                                                                                       
%*                                                                                                 *;                                                                                                                                                                                                                                       
%* History                                                                                         *;
%* 2021-06-10  Initial coding                                                                      *;
%* 2021-08-17  Remove header documentation                                                         *;
%* 2021-08-25  DE16781                                                                             *;
%*                                                                                                 *;                                                                                                                                                                                                                                       
                                                                                                                                                                                                                                                                                                                                     
%macro lsaf_gettlftemplateid( lsaf_name= ) /des='Gets the TLF template alphanumeric ID';                                                                                                                                                                                                                                                                                 
                                                                                                                                                                                                                                                                                                                                     
  %****************************************;                                                                                                                                                                                                                                                                                         
  %* Initialize macro variables           *;                                                                                                                                                                                                                                                                                         
  %****************************************;                                                                                                                                                                                                                                                                                         
  %lsaf_getproductname();                                                                                                                                                                                                                                                                                                            
                                                                                                                                                                                                                                                                                                                                     
  %global _lsafMsg_
          _lsafRC_ 
          _lsafTlfTemplateId_
  ;                                                                                                                                                                                                                                                                                                                                  
                                                                                                                                                                                                                                                                                                                                     
  %let _lsafRC_ =%str(-999);                                                                                                                                                                                                                                                                                                         
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);                                                                                                                                                                                                                                                
                                                                                                                                                                                                                                                                                                                                     
  %**********************************************;                                                                                                                                                                                                                                                                                   
  %* Start the datastep to call the java code   *;                                                                                                                                                                                                                                                                                   
  %**********************************************;                                                                                                                                                                                                                                                                                   
  data _null_;                                                                                                                                                                                                                                                                                                                       
    attrib returnCode      length=8;                                                                                                                                                                                                                                                                                                 
    attrib message         length=$200;                                                                                                                                                                                                                                                                                              
    attrib templateID      length=$70;                                                                                                                                                                                                                                                                                               
    attrib logMsgPrefix    length=$70;                                                                                                                                                                                                                                                                                               
    attrib logMsgPrimary   length=$70;                                                                                                                                                                                                                                                                                               
    attrib logMsg          length=$300;                                                                                                                                                                                                                                                                                              
                                                                                                                                                                                                                                                                                                                                     
    %***********************************;                                                                                                                                                                                                                                                                                            
    %* Declare the java objects        *;                                                                                                                                                                                                                                                                                            
    %***********************************;                                                                                                                                                                                                                                                                                            
    declare javaobj srv("com/sas/lsaf/macro/clinical/tlf/TlfTemplateService");                                                                                                                                                                                                                                                              
    declare javaobj results("com/sas/lsaf/macro/common/result/Result");                                                                                                                                                                                                                                                                     
                                                                                                                                                                                                                                                                                                                                     
    %***********************************;                                                                                                                                                                                                                                                                                            
    %* Attempt the operation           *;                                                                                                                                                                                                                                                                                            
    %***********************************;                                                                                                                                                                                                                                                                                            
    srv.callStaticStringMethod("getTlfTemplateId", "%bquote(&lsaf_name)", results, templateID);

    %***********************************;                                                                                                                                                                                                                                                                                            
    %* Retrieve the results            *;                                                                                                                                                                                                                                                                                            
    %***********************************;                                                                                                                                                                                                                                                                                            
    results.callIntMethod("getReturnCode", returnCode);                                                                                                                                                                                                                                                                              
    results.callStringMethod("getReturnMessage", message);                                                                                                                                                                                                                                                                           
                                                                                                                                                                                                                                                                                                                                     
    %***********************************;                                                                                                                                                                                                                                                                                            
    %* Process the results             *;                                                                                                                                                                                                                                                                                            
    %***********************************; 
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    logMsgPrimary=logMsgPrefix;
    logMsg=" The TLF template ID was returned." ;
    if (returnCode ne 0) then
    do;
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
      logMsg=" The TLF template ID was not returned.";
    end;
                                                                                                                                                                                                                                                                                                                                     
    %***********************************;                                                                                                                                                                                                                                                                                            
    %* Print messages in log           *;                                                                                                                                                                                                                                                                                            
    %***********************************;                                                                                                                                                                                                                                                                                            
    put;                                                                                                                                                                                                                                                                                                                             
    put logMsgPrimary " " logMsg;                                                                                                                                                                                                                                                                                                     
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));                                                                                                                                                                                                                                                                         
    put logMsgPrefix " _lsafMsg_= " message;                                                                                                                                                                                                                                                                                         
    put logMsgPrefix " _lsafRC_= " returnCode;                                                                                                                                                                                                                                                                                       
    put logMsgPrefix " _lsafTlfTemplateId_= " templateID;                                                                                                                                                                                                                                                                                       
    put;                                                                                                                                                                                                                                                                                                                             
                                                                                                                                                                                                                                                                                                                                     
    %***********************************;                                                                                                                                                                                                                                                                                            
    %* Set the macro variables         *;                                                                                                                                                                                                                                                                                            
    %***********************************;                                                                                                                                                                                                                                                                                            
    call symputx("_lsafRC_", returnCode);                                                                                                                                                                                                                                                                                            
    call symputx("_lsafMsg_", message);  
    call symputx("_lsafTlfTemplateId_", templateID);
                                                                                                                                                                                                                                                                                                                                     
  run;                                                                                                                                                                                                                                                                                                                               
                                                                                                                                                                                                                                                                                                                                     
%mend lsaf_gettlftemplateid;                                                                                                                                                                                                                                                                                                            