%* lsaf_getsubmissionstatus                                                                      *;
%*                                                                                               *;
%* Gets the status of a repository or workspace job submission.                                  *;
%*                                                                                               *;
%* macrotype LSAF                                                                                *;
%* since 1.4                                                                                     *;
%* exposure external                                                                             *;
%*                                                                                               *;
%* History                                                                                       *;
%* 2014-04-07  initial code                                                                      *;
%* 2016-08-26  rebrand as LSAF                                                                   *;
%* 2016-11-02  added job submission message, updated doc                                         *;
%* 2019-02-11  update to 2.1                                                                     *;
%* 2020-03-02  DE14415 fix                                                                       *;
%* 2020-06-30  update service location                                                           *;
%* 2021-08-09  Remove header documentation                                                       *;
%*                                                                                               *;

%macro lsaf_getsubmissionstatus(
  lsaf_jobsubmission_id=
  ) /des='What is the submission status of SAS Life Science Analytics Framework job?';

  %****************************************;
  %* Initialize macro variables           *;
  %****************************************;
  %lsaf_getProductName();

  %global _lsafJobSubmissionStatus_
          _lsafMsg_
          _lsafRC_
  ;

  %let _lsafRC_ =%str(-999);
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);

  %**********************************************;
  %* Start the datastep to call the java code   *;
  %**********************************************;
  data _null_;
    attrib returnCode      length=8
           message         length=$200
           logMsgPrefix    length=$70
           logMsgPrimary   length=$70
           logMsg          length=$300
           status          length=$200
           msgLevel        length=$200
           jobMsg          length=$300
    ;

    status="";
    msgLevel="";
    jobMsg="";

    %***********************************;
    %* Declare the java objects        *;
    %***********************************;
    declare javaobj srv("com/sas/lsaf/macro/execution/jobsubmission/JobSubmissionService");
    declare javaobj results("com/sas/lsaf/macro/execution/jobsubmission/SasJobSubmissionStatusResult");

    %***********************************;
    %* Attempt the operation           *;
    %***********************************;
    srv.callStaticVoidMethod("getJobSubmissionStatus", "%bquote(&lsaf_jobsubmission_id)", results);
    results.callStringMethod("getStatus", status);

    %***********************************;
    %* Retrieve the results            *;
    %***********************************;
    results.callIntMethod("getReturnCode", returnCode);
    results.callStringMethod("getReturnMessage", message);

    %***********************************;
    %* Process the results             *;
    %***********************************;
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    if (returnCode ne 0) then
    do;
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
      logMsg=" Cannot determine submission status for identifier: &lsaf_jobsubmission_id.." ;
    end;
    else
    do;
      logMsgPrimary=logMsgPrefix;
      logMsg=" Returned submission status: &lsaf_jobsubmission_id.." ;
    end;

    %***********************************;
    %* Print messages in log           *;
    %***********************************;
    put;
    put logMsgPrimary " " logMsg;
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));
    put logMsgPrefix " _lsafMsg_= " message;
    put logMsgPrefix " _lsafRC_= " returnCode;
    put logMsgPrefix " _lsafJobSubmissionStatus_= " status;
    if (returnCode EQ 0) then
    do;
       results.callStringMethod("getStatusMessage", jobMsg);
       if (jobMsg NE "") then
       do;
          results.callStringMethod("getLogMsgLevel", msgLevel);
          msgText= strip(msgLevel) || ": &_LSAF_PRODUCT_NAME_ Macro: * " ||  strip(jobMsg);
          put msgText;
       end;
    end;
    put;

    %***********************************;
    %* Set the macro variables         *;
    %***********************************;
    call symputx("_lsafRC_", returnCode);
    call symputx("_lsafMsg_", message);
    call symputx("_lsafJobSubmissionStatus_", strip(status) ) ;

  run;

%mend lsaf_getsubmissionstatus;
