%* lsaf_getstudytlfsections                                                                 *;
%*                                                                                          *;
%* Gets a list of TLF sections.                                                             *;
%*                                                                                          *;
%* macrotype LSAF                                                                           *;
%* since 2.5                                                                                *;
%* exposure external                                                                        *;
%*                                                                                          *;
%* History                                                                                  *;
%* 2020-03-25  initial coding.                                                              *;
%* 2021-08-17  Remove header documentation                                                  *;
%*                                                                                          *;

%macro lsaf_getstudytlfsections(
  lsaf_studyId=, 
  lsaf_basestandardname=,
  lsaf_modelId=,
  sas_dsname=work.lsafgetstudytlfsections
  ) /des='Gets a list of TLF sections.';
  
  %if "&sas_dsname" EQ "" %then %let sas_dsname=work.lsafgetstudytlfsections;

  %****************************************;
  %* Initialize macro variables           *;
  %****************************************;
  %lsaf_getProductName();

  %global _lsafMsg_
          _lsafRC_
  ;

  %let _lsafRC_ =%str(-999);
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);

  %**********************************************;
  %* Start the datastep to call the java code   *;
  %**********************************************;
  data &sas_dsname. (keep=studyId baseStandardName modelId parentSectionId sectionId sectionName sectionIdentifier sectionDescription);
    attrib returnCode      length=8
           message         length=$200
           logMsgPrefix    length=$70
           logMsgPrimary   length=$70
           logMsg          length=$300
           rowCount        length=8

           studyId            length=$70   label="Study ID" 
           baseStandardName   length=$15   label="Base Data Standard Name" 
           modelId            length=$64   label="Model ID"
           parentSectionId    length=$64   label="Parent Section ID"
           sectionId          length=$64   label="Section ID"
           sectionName        length=$256  label="Section Name"
           sectionIdentifier  length=$200  label="Section Identifier"
           sectionDescription length=$256  label="Section Description"
    ;

    rowCount=0;

    %***********************************;
    %* Declare the java objects        *;
    %***********************************;
    declare javaobj srv("com/sas/lsaf/macro/clinical/study/tlf/StudyTlfService");
    declare javaobj results("com/sas/lsaf/macro/clinical/study/tlf/SasStudyTlfSectionsResult");

    %***********************************;
    %* Attempt the operation           *;
    %***********************************;
    srv.callStaticVoidMethod("getTlfSections", "%bquote(&lsaf_studyId)", "%bquote(&lsaf_baseStandardName)", 
                             "%bquote(&lsaf_modelId)", results) ;

    %***********************************;
    %* Retrieve the results            *;
    %***********************************;
    results.callIntMethod("getReturnCode", returnCode);
    results.callStringMethod("getReturnMessage", message);

    %***********************************;
    %* Process the results             *;
    %***********************************;
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    if (returnCode ne 0) then
    do;
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
      logMsg=" Cannot retrieve tlf sections for the study." ;
    end;
    else
    do;
      logMsgPrimary=logMsgPrefix;
      logMsg=" Study TLF section were returned for the study." ;
      results.callIntMethod("getSize", rowCount);
      studyId = "&lsaf_studyId";
      baseStandardName = "&lsaf_baseStandardName";
      modelId = "&lsaf_modelId";
      do row=0 to rowCount - 1;
        results.callStringMethod("getId", row, sectionId);
        results.callStringMethod("getName", row, sectionName);
        results.callStringMethod("getIdentifier", row, sectionIdentifier);
        results.callStringMethod("getDescription", row, sectionDescription);
        results.callStringMethod("getParentId", row, parentSectionId);
        output;
      end;
    end;

    %***********************************;
    %* Print messages in log           *;
    %***********************************;
    put;
    put logMsgPrimary " " logMsg;
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));
    if (rowCount=0) 
      then put logMsgPrefix " No study TLF sections were found.";
      else put logMsgPrefix " " rowCount " records written to data set &sas_dsname";
    put logMsgPrefix " _lsafMsg_= " message ;
    put logMsgPrefix " _lsafRC_= " returnCode ;
    put;

    %***********************************;
    %* Set the macro variables         *;
    %***********************************;
    call symputx("_lsafRC_", returnCode);
    call symputx("_lsafMsg_", message);
    call symputx("_lsafRowCount_", rowCount);
  run;

%mend lsaf_getstudytlfsections;
