%* lsaf_getstudytlfproperties                         *;
%*                                                    *;
%* Gets the properties for the specified study tlf.   *;
%*                                                    *;
%* macrotype LSAF                                     *;
%* since 2.5                                          *;
%* exposure external                                  *;
%*                                                    *;
%* History                                            *;
%* 2021-03-24  initial coding                         *;
%* 2021-08-17  Remove header documentation            *;
%* 2021-10-12  US11739                                *;
%*                                                    *;

%macro lsaf_getstudytlfproperties(
  lsaf_studyId=, 
  lsaf_basestandardname=,
  lsaf_modelId=,
  lsaf_tlfIdentifier=,
  sas_dsname=work.lsafgetstudytlfproperties
  ) /des='Get a list of TLF properties.';
  
  %if "&sas_dsname" EQ "" %then %let sas_dsname=work.lsafgetstudytlfproperties;

  %****************************************;
  %* Initialize macro variables           *;
  %****************************************;
  %lsaf_getProductName();

  %global _lsafMsg_
          _lsafRC_
  ;

  %local _lsafRowCount_;

  %let _lsafRC_ =%str(-999);
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);
  %let _lsafRowCount_=0;

  %**********************************************;
  %* Start the datastep to call the java code   *;
  %**********************************************;
  data &sas_dsname(label="Created by &SYSMACRONAME"
                    keep=studyId baseStandardName modelId tlfIdentifier sasName name description dataType logicalType 
                         dataLength ordering isRequired mustbeunique allowedvalues value valuequalifier
   );
    attrib returnCode      length=8
           message         length=$200
           rowCount        length=8

           studyId            length=$70    label="Study ID"
           baseStandardName   length=$15    label="Base Data Standard Name"
           modelId            length=$64    label="Model ID"
           tlfIdentifier      length=$256   label="TLF Identifier"
           sasName            length=$32    label="SAS Name of the Property"
           name               length=$256   label="Property Name"
           description        length=$200   label="Property Description"
           ordering           length=8      label="Property Display Order"
           dataType           length=$15    label="Property Data Type"
           logicalType        length=$15    label="Property Logical Type"
           dataLength         length=8      label="Maximum Length of Property Value"
           isRequired         length=8      label="Property Required"
           mustbeunique       length=8      label="Property Unique Among TLFs within the Model ID"
           allowedvalues      length=$3000  label="Allowed Valid Values"
           value              length=$3000  label="Property Value"
           valueQualifier     length=$2064  label="Property Value Qualifier"
    ;

    rowCount=0;

    %***********************************;
    %* Declare the java objects        *;
    %***********************************;
    declare javaobj srv("com/sas/lsaf/macro/clinical/study/tlf/StudyTlfService") ;
    declare javaobj results("com/sas/lsaf/macro/clinical/study/tlf/SasStudyTlfPropertiesResult");

    %***********************************;
    %* Attempt the operation           *;
    %***********************************;
    srv.callStaticVoidMethod("getTlfProperties", "%bquote(&lsaf_studyId)", "%bquote(&lsaf_baseStandardName)", "%bquote(&lsaf_modelId)",
			     "%bquote(&lsaf_tlfIdentifier)", results) ;

    %***********************************;
    %* Retrieve the results            *;
    %***********************************;
    results.callIntMethod("getReturnCode", returnCode);
    results.callStringMethod("getReturnMessage", message);

    %***********************************;
    %* Process the results             *;
    %***********************************;
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    if (returnCode ne 0) then
    do;
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
      logMsg=" Cannot retrieve list of TLF properties.";
    end;
    else
    do;
      logMsgPrimary=logMsgPrefix;
      logMsg=" List of TLF properties was returned.";
      results.callIntMethod("getSize", rowCount);
      studyId="&lsaf_studyId";
      baseStandardName="&lsaf_basestandardname"; 
      modelId="&lsaf_modelId";   
      do row=0 to rowCount - 1;
        results.callStringMethod("getTlfIdentifier", row, tlfIdentifier);
        results.callStringMethod("getName", row, name);
        results.callStringMethod("getSasName", row, sasName);
        results.callStringMethod("getDescription", row, description);
        results.callIntMethod("getOrdering", row, ordering);
        results.callStringMethod("getDataType", row, dataType);
        results.callStringMethod("getLogicalType", row, logicalType);
        results.callIntMethod("getLength", row, dataLength);
        results.callBooleanMethod("isRequired", row, isRequired);
        results.callBooleanMethod("mustBeUnique", row, mustbeunique);
        results.callStringMethod("getAllowedValues", row, allowedvalues);
        results.callStringMethod("getValue", row, value);        
        results.callStringMethod("getValueQualifier", row, valuequalifier);        
        output;
      end;
    end;

    %***********************************;
    %* Print messages in log           *;
    %***********************************;
    put;
    put logMsgPrimary " " logMsg;
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));
    if (rowCount=0) 
      then put logMsgPrefix " No TLF properties were found.";
      else put logMsgPrefix " " rowCount " records written to data set &sas_dsname";
    put logMsgPrefix " _lsafMsg_= " message ;
    put logMsgPrefix " _lsafRC_= " returnCode ;
    put;

    %***********************************;
    %* Set the macro variables         *;
    %***********************************;
    call symputx("_lsafRC_", returnCode);
    call symputx("_lsafMsg_", message);
    call symputx("_lsafRowCount_", rowCount);

  run;

  %***********************************;
  %* Sort the data set               *;
  %***********************************;
  %if (&_lsafRowCount_ > 0) %then
  %do;
    %let notesOption=%sysfunc(getoption(notes));
    options nonotes;
    proc sort data=&sas_dsname. sortseq=linguistic(strength=primary);
      by studyId baseStandardName tlfIdentifier modelId ordering;
    run;
    options &notesOption;
  %end;

%mend lsaf_getstudytlfproperties;
