%* lsaf_getsigningstatus                                                                   *;
%*                                                                                         *;
%* Gets the status of a signature for the current file.                                    *;
%*                                                                                         *;
%* macrotype LSAF                                                                          *;
%* since 2.3                                                                               *;
%* exposure external                                                                       *;
%*                                                                                         *;
%* History                                                                                 *;
%* 2020-01-30  initial code                                                                *;
%* 2020-07-13  update for refactor of java service hierarchy.                              *;
%* 2021-08-16  Remove header documentation                                                 *;
%*                                                                                         *;

%macro lsaf_getsigningstatus(
  lsaf_path=
  ) /des='Returns the status of a signature.';

  %****************************************;
  %* Initialize macro variables           *;
  %****************************************;
  %lsaf_getProductName();

  %global _lsafMsg_         
          _lsafRC_
          _lsafSigningStatus_
  ;

  %let _lsafRC_ =%str(-999);
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);

  %**********************************************;
  %* Start the datastep to call the java code   *;
  %**********************************************;
  data _null_;
    attrib returnCode      length=8;
    attrib message         length=$200;
    attrib logMsgPrefix    length=$70;
    attrib logMsgPrimary   length=$70;
    attrib logMsg          length=$300;
    attrib status          length=$25;

    status="";

    %***********************************;
    %* Declare the java objects        *;
    %***********************************;
    declare javaobj srv("com/sas/lsaf/macro/content/repository/signature/SignatureService") ;
    declare javaobj results("com/sas/lsaf/macro/common/result/Result");

    %***********************************;
    %* Attempt the operation           *;
    %***********************************;
    srv.callStaticStringMethod("getSigningStatus", "%bquote(&lsaf_path)", results, status);

    %***********************************;
    %* Retrieve the results            *;
    %***********************************;
    results.callIntMethod("getReturnCode", returnCode);
    results.callStringMethod("getReturnMessage", message);

    %***********************************;
    %* Process the results             *;
    %***********************************;
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    if (returnCode ne 0) then
    do;
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
      logMsg=" Cannot determine signing status: &lsaf_path." ;
    end;
    else
    do;
      logMsgPrimary=logMsgPrefix;
      logMsg=" Returned signing status: &lsaf_path." ;
    end;

    %***********************************;
    %* Print messages in log           *;
    %***********************************;
    put;
    put logMsgPrimary " " logMsg;
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));
    put logMsgPrefix " _lsafMsg_= " message;
    put logMsgPrefix " _lsafRC_= " returnCode;
    put logMsgPrefix " _lsafSigningStatus_= " status;
    put;

    %***********************************;
    %* Set the macro variables         *;
    %***********************************;
    call symputx("_lsafRC_", returnCode);
    call symputx("_lsafMsg_", message);
    call symputx("_lsafSigningStatus_", strip(status) ) ;

  run;

%mend lsaf_getsigningstatus;
