%* lsaf_getsessionstate                                                                                  *;
%*                                                                                                       *;
%* Returns the state of a session.                                                                       *;
%*                                                                                                       *;
%* macrotype LSAF                                                                                        *;
%* since 2.3                                                                                             *;
%* exposure external                                                                                     *;
%*                                                                                                       *;
%* History                                                                                               *;
%* 2019-12-02  initial code                                                                              *;
%* 2021-08-16  Remove header documentation                                                               *;
%*                                                                                                       *;

%macro lsaf_getsessionstate(
  lsaf_sessionid=,
  ) /des='Retrieve the current state of a session.';

  %****************************************;
  %* Initialize macro variables           *;
  %****************************************;
  %lsaf_getProductName();

  %global _lsafMsg_
          _lsafRC_
          _lsafSessionState_
  ;

  %let _lsafRC_ =%str(-999);
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);

  %**********************************************;
  %* Start the datastep to call the java code   *;
  %**********************************************;
  data _null_;
    attrib returnCode      length=8
           message         length=$200
           logMsgPrefix    length=$70
           logMsgPrimary   length=$70
           logMsg          length=$300
           sessionstate    length=$20
           ;

    %***********************************;
    %* Declare the java objects        *;
    %***********************************;
    declare javaobj srv("com/sas/lsaf/macro/execution/session/SessionService");
    declare javaobj results("com/sas/lsaf/macro/common/result/Result");

    %***********************************;
    %* Attempt the operation           *;
    %***********************************;
    srv.callStaticStringMethod("getSessionState", "%bquote(&lsaf_sessionid)", results, sessionstate);

    %***********************************;
    %* Retrieve the results            *;
    %***********************************;
    results.callIntMethod("getReturnCode", returnCode);
    results.callStringMethod("getReturnMessage", message);

    %***********************************;
    %* Process the results             *;
    %***********************************;
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    if (returnCode ne 0) then
    do;
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
      logMsg=" Cannot retrieve session state for: &lsaf_sessionid..";
    end;
    else
    do;
      logMsgPrimary=logMsgPrefix;
      logMsg=" The session state for: &lsaf_sessionid was retrieved.";
    end;

    %***********************************;
    %* Print messages in log           *;
    %***********************************;
    put;
    put logMsgPrimary " " logMsg;
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));
    put logMsgPrefix " _lsafMsg_= " message;
    put logMsgPrefix " _lsafRC_= " returnCode;
    put logMsgPrefix " _lsafSessionState_= " sessionstate;
    put;

    %***********************************;
    %* Set the macro variables         *;
    %***********************************;
    call symputx("_lsafRC_", returnCode);
    call symputx("_lsafMsg_", message);
    call symputx("_lsafSessionState_", sessionstate) ;

  run;

%mend lsaf_getsessionstate;
