%* lsaf_getsessionlistsize                                                                          *;
%*                                                                                                  *;
%* Returns the list size of a session.                                                              *;
%*                                                                                                  *;
%* macrotype LSAF                                                                                   *;
%* since 2.3                                                                                        *;
%* exposure external                                                                                *;
%*                                                                                                  *;
%* History                                                                                          *;
%* 2020-01-21  initial coding                                                                       *;
%* 2021-08-16  Remove header documentation                                                          *;
%* 2021-09-20  Remove parameter defaults (DE16775)                                                  *;
%*                                                                                                  *;

%macro lsaf_getsessionlistsize(
  lsaf_sessionid=,
  lsaf_formatvalue=
  ) /des='Get the session list file size.';

  %****************************************;
  %* Initialize macro variables           *;
  %****************************************;
  %lsaf_getProductName();

  %global _lsafMsg_
          _lsafOwner_
          _lsafRC_
          _lsafSessionListSize_
  ;

  %let _lsafRC_ =%str(-999);
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);

  %**********************************************;
  %* Start the datastep to call the java code   *;
  %**********************************************;
  data _null_;
    attrib returnCode      length=8;
    attrib message         length=$200;
    attrib logMsgPrefix    length=$70;
    attrib logMsgPrimary   length=$70;
    attrib logMsg          length=$300;
    attrib listsize        length=$64;

    %***********************************;
    %* Declare the java objects        *;
    %***********************************;
    declare javaobj srv("com/sas/lsaf/macro/execution/session/SessionService") ;
    declare javaobj results("com/sas/lsaf/macro/common/result/Result");

    %***********************************;
    %* Attempt the operation           *;
    %***********************************;
    srv.callStaticStringMethod("getSessionListSize", "%bquote(&lsaf_sessionid)",  "%bquote(&lsaf_formatvalue)", results, listsize);

    %***********************************;
    %* Retrieve the results            *;
    %***********************************;
    results.callIntMethod("getReturnCode", returnCode);
    results.callStringMethod("getReturnMessage", message);

    %***********************************;
    %* Process the results             *;
    %***********************************;
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    if (returnCode ne 0) then
    do;
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
      logMsg=" Cannot retrieve the session list file size for session &lsaf_sessionid.." ;
    end;
    else
    do;
      logMsgPrimary=logMsgPrefix;
      logMsg=" The session list file size for session &lsaf_sessionid is " || listsize ;
    end;

    %***********************************;
    %* Print messages in log           *;
    %***********************************;
    put;
    put logMsgPrimary " " logMsg;
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));
    put logMsgPrefix " _lsafMsg_= " message ;
    put logMsgPrefix " _lsafRC_= " returnCode ;
    put logMsgPrefix " _lsafSessionListSize_= " listsize;
    put;

    %***********************************;
    %* Set the macro variables         *;
    %***********************************;
    call symputx("_lsafRC_", returnCode);
    call symputx("_lsafMsg_", message);
    call symputx("_lsafSessionListSize_", listsize) ;

  run;

%mend lsaf_getsessionlistsize;
