%* lsaf_getresourceutilization                                                                      *;
%*                                                                                                  *;
%* Gets the resource utilization summary information.                                               *;
%*                                                                                                  *;
%* macrotype LSAF                                                                                   *;
%* since 2.5                                                                                        *;
%* exposure external                                                                                *;
%*                                                                                                  *;
%* History                                                                                          *;
%* 2021-04-09  initial programming                                                                  *;
%* 2021-08-13  Remove header documentation                                                          *;
%* 2021-08-25  DE16767                                                                              *;
%* 2024-08-20  US11873 - Add unformatted size and added precision to format.                        *;
%*                                                                                                  *;

%macro lsaf_getresourceutilization(
  sas_dsname=work.lsafgetresourceutilization
  ) /des='Gets the resource utilization summary information.';
  
  %if "&sas_dsname" EQ "" %then %let sas_dsname=work.lsafgetresourceutilization;

  %****************************************;
  %* Initialize macro variables           *;
  %****************************************;
  %lsaf_getProductName();

  %global _lsafMsg_
          _lsafRC_
  ;

  %let _lsafRC_ =%str(-999);
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);

  %**********************************************;
  %* Start the datastep to call the java code   *;
  %**********************************************;
  data &sas_dsname (label="Created by &SYSMACRONAME"
                    keep=type workArea size unformattedsize);

    attrib returnCode       length=8
           message          length=$200
           logMsgPrefix     length=$70
           logMsgPrimary    length=$70
           logMsg           length=$300
           rowCount         length=8

           type             length=$32   label="Data Type"
           workArea         length=$32   label="The Work Area Referenced by the Data"
           size             length=8     label="Size of Data - Formatted"      format=sizekmg12.2
           unformattedsize  length=8     label="Size of Data - Unformatted"
    ;

    rowCount=0;
    
    %***********************************;
    %* Declare the java objects        *;
    %***********************************;
    
    declare javaobj srv("com/sas/lsaf/macro/content/utilization/ResourceUtilizationService") ;
    declare javaobj results("com/sas/lsaf/macro/content/utilization/SasUtilizationSummaryResult");

    %***********************************;
    %* Attempt the operation           *;
    %***********************************;
    srv.callStaticVoidMethod("getUtilizationSummary", results) ;

    %***********************************;
    %* Retrieve the results            *;
    %***********************************;
    results.callIntMethod("getReturnCode", returnCode);
    results.callStringMethod("getReturnMessage", message);

    %***********************************;
    %* Process the results             *;
    %***********************************;
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    if (returnCode ne 0) then
    do;
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
      logMsg=" Cannot retrieve resource utilization summary information." ;
    end;
    else
    do;
      logMsgPrimary=logMsgPrefix;
      logMsg=" Get resource utilization summary information ran successfully." ;
      results.callIntMethod("getSize", rowCount);
      do row=0 to rowCount - 1;
        results.callStringMethod("getSummaryType", row, type);
        results.callStringMethod("getSummaryWorkarea", row, workArea);
        results.callLongMethod("getSummarySize", row, size);
        unformattedsize=size;
        output;
      end;
    end;

    %***********************************;
    %* Print messages in log           *;
    %***********************************;
    put;
    put logMsgPrimary " " logMsg;
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));
    if (rowCount=0) 
      then put logMsgPrefix " No resource utilization summary information was found.";
      else put logMsgPrefix " " rowCount " records written to data set &sas_dsname";
    put logMsgPrefix " _lsafMsg_= " message ;
    put logMsgPrefix " _lsafRC_= " returnCode ;
    put;

    %***********************************;
    %* Set the macro variables         *;
    %***********************************;
    call symputx("_lsafRC_", returnCode);
    call symputx("_lsafMsg_", message);

  run;

%mend lsaf_getresourceutilization;
