%* lsaf_getrelativepath                                                                           *;
%*                                                                                                *;
%* Gets a relative path for an item relative to the specified base path.                          *;
%*                                                                                                *;
%* macrotype LSAF                                                                                 *;
%* since 1.5                                                                                      *;
%* exposure external                                                                              *;
%*                                                                                                *;
%* History                                                                                        *;
%* 2016-10-25  original coding                                                                    *;
%* 2019-02-13  update to 2.1                                                                      *;
%* 2020-07-13  update for refactor of java service hierarchy.                                     *;
%* 2021-08-18  Remove header documentation                                                        *;
%*                                                                                                *;

%macro lsaf_getrelativepath(
  lsaf_base_path=,
  lsaf_absolute_path=
  ) /des='Get the path relative to the base path.';

  %****************************************;
  %* Initialize macro variables           *;
  %****************************************;
  %lsaf_getProductName();

  %global _lsafMsg_
          _lsafRC_
          _lsafRelativePath_
  ;

  %let _lsafRC_ =%str(-999);
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);

  %**********************************************;
  %* Start the datastep to call the java code   *;
  %**********************************************;
  data _null_;
    attrib returnCode      length=8
           message         length=$200
           logMsgPrefix    length=$70
           logMsgPrimary   length=$70
           logMsg          length=$300
           relativePath    length=$2048
    ;

    %***********************************;
    %* Declare the java objects        *;
    %***********************************;
    declare javaobj srv("com/sas/lsaf/macro/core/utility/UtilityService") ;
    declare javaobj results("com/sas/lsaf/macro/common/result/Result");

    %***********************************;
    %* Attempt the operation           *;
    %***********************************;
    srv.callStaticStringMethod("getRelativePath", "%bquote(&lsaf_base_path)", "%bquote(&lsaf_absolute_path)", results, relativePath);

    %***********************************;
    %* Retrieve the results            *;
    %***********************************;
    results.callIntMethod("getReturnCode", returnCode);
    results.callStringMethod("getReturnMessage", message);

    %***********************************;
    %* Process the results             *;
    %***********************************;
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    if (returnCode ne 0) then
    do;
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
      logMsg=" Cannot generate relative path for &lsaf_absolute_path. based on &lsaf_base_path." ;
    end;
    else
    do;
      logMsgPrimary=logMsgPrefix;
      logMsg=" The relative path was generated: " || kstrip(relativePath) ;
    end;

    %***********************************;
    %* Print messages in log           *;
    %***********************************;
    put;
    put logMsgPrimary " " logMsg;
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));
    put logMsgPrefix " _lsafMsg_= " message ;
    put logMsgPrefix " _lsafRC_= " returnCode ;
    put logMsgPrefix " _lsafRelativePath_= " relativePath;
    put;

    %***********************************;
    %* Set the macro variables         *;
    %***********************************;
    call symputx("_lsafRC_", returnCode);
    call symputx("_lsafMsg_", message);
    call symputx("_lsafRelativePath_", kstrip(relativePath)) ;

  run;

%mend lsaf_getrelativepath;
