%* lsaf_getquerytemplatedataset                                                                       *;
%*                                                                                                    *;
%* Gets the structure that is required as input to the macros that query the system. The metadata is  *;
%* stored in a SAS data set with zero observations.                                                   *;
%*                                                                                                    *;
%* macrotype LSAF                                                                                     *;
%* since 2.3                                                                                          *;
%* exposure external                                                                                  *;
%*                                                                                                    *;
%* History                                                                                            *;
%* 2020-03-24  initial coding                                                                         *;
%* 2021-08-12  Remove header documentation                                                            *;
%*                                                                                                    *;

%macro lsaf_getquerytemplatedataset(
  sas_dsname=work.lsafgetquerytemplatedataset
  ) /des='Get a query template data set for an LSAF query.';
  
  %if "&sas_dsname" EQ "" %then %let sas_dsname=work.lsafgetquerytemplatedataset;

  %****************************************;
  %* Initialize macro variables           *;
  %****************************************;
  %lsaf_getProductName();

  %global _lsafMsg_
          _lsafRC_
  ;

  %local _lsafRowCount_;

  %let _lsafRC_ =%str(-999);
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);
  %let _lsafRowCount_=0;

  %**********************************************;
  %* Start the datastep to call the java code   *;
  %**********************************************;
  data &sas_dsname (label="Created by &SYSMACRONAME"
                    keep=recordType columnClass columnName value comparator isCaseSensitive 
    );

    attrib logMsgPrefix            length=$70;
    attrib logMsgPrimary           length=$70;
    attrib logMsg                  length=$300;

    attrib recordType              length=$32    label="Record Type";
    attrib columnClass             length=$32    label="Column Class";
    attrib columnName              length=$32    label="Column Name";
    attrib value                   length=$2048  label="Value Type";
    attrib comparator              length=$32    label="Comparator";
    attrib isCaseSensitive         length=8      label="Is Case Sensitive";
    
    recordType='';
    columnClass='';
    columnName='';
    value='';
    comparator='';
    isCaseSensitive=.;

    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    logMsgPrimary=logMsgPrefix;
    logMsg=" A query template data set was created.";

    %***********************************;
    %* Print messages in log           *;
    %***********************************;
    put;
    put logMsgPrimary " " logMsg;
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));
    put logMsgPrefix " _lsafRC_= 0";
    put;

    %***********************************;
    %* Set the macro variables         *;
    %***********************************;
    logMsg="Success";
    call symputx("_lsafRC_", 0);
    call symputx("_lsafMsg_", logMsg);
    call symputx("_lsafRowCount_", 0);

    if _n_ <1;

  run;

%mend lsaf_getquerytemplatedataset;
