%* lsaf_getproductName                                                       *;
%*                                                                           *;
%* Sets the macro variable _LSAF_PRODUCT_NAME_ to the hardcoded product name *;
%* "SAS Life Science Analytics Framework".                                   *;
%*                                                                           *;
%* This macro is called from all lsaf_xxx macros for log messaging.          *;
%*                                                                           *;
%* Syntax:                                                                   *;
%* %LSAF_GETPRODUCTNAME();                                                   *;
%*                                                                           *;
%* macvar _LSAF_PRODUCT_NAME_ product name.                                  *;
%*                                                                           *;
%* macrotype LSAF                                                            *;
%* since 1.5                                                                 *;
%* exposure internal                                                         *;
%*                                                                           *;
%* History                                                                   *;
%* 2016-08-26  initial code                                                  *;
%* 2021-08-18  Update header documentation                                   *;
%*                                                                           *;

%macro lsaf_getproductname(
   )   /des='Get product name for LSAF';

  %****************************************;
  %* Initialize macro variables           *;
  %****************************************;
   %global _LSAF_PRODUCT_NAME_;

   %let _LSAF_PRODUCT_NAME_=SAS Life Science Analytics Framework;

%mend lsaf_getproductname;
