%* lsaf_getprocessdefinitionstatus                                                                 *;                                                                                                                                                                                                                                       
%*                                                                                                 *;                                                                                                                                                                                                                                       
%* Gets the status of a process flow definition. The Manage Process Flows privilege is required.   *;
%*                                                                                                 *;                                                                                                                                                                                                                                       
%* macrotype LSAF                                                                                  *;                                                                                                                                                                                                                                       
%* since 2.2                                                                                       *;                                                                                                                                                                                                                                       
%* exposure external                                                                               *;                                                                                                                                                                                                                                       
%*                                                                                                 *;                                                                                                                                                                                                                                       
%* History                                                                                         *;
%* 2019-09-19  Initial coding                                                                      *;
%* 2021-08-10  Remove header documentation                                                         *;
%*                                                                                                 *;                                                                                                                                                                                                                                       
                                                                                                                                                                                                                                                                                                                                     
%macro lsaf_getprocessdefinitionstatus(
  lsaf_processdefid=
  ) /des='Gets the status of a process flow definition within the SAS Life Science Analytics Framework.';                                                                                                                                                                                                                                                                                 
                                                                                                                                                                                                                                                                                                                                     
  %****************************************;                                                                                                                                                                                                                                                                                         
  %* Initialize macro variables           *;                                                                                                                                                                                                                                                                                         
  %****************************************;                                                                                                                                                                                                                                                                                         
  %lsaf_getproductname();                                                                                                                                                                                                                                                                                                            
                                                                                                                                                                                                                                                                                                                                     
  %global _lsafMsg_
          _lsafRC_ 
          _lsafProcessDefinitionStatus_
  ;                                                                                                                                                                                                                                                                                                                                  
                                                                                                                                                                                                                                                                                                                                     
  %let _lsafRC_ =%str(-999);                                                                                                                                                                                                                                                                                                         
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);                                                                                                                                                                                                                                                
                                                                                                                                                                                                                                                                                                                                     
  %**********************************************;                                                                                                                                                                                                                                                                                   
  %* Start the datastep to call the java code   *;                                                                                                                                                                                                                                                                                   
  %**********************************************;                                                                                                                                                                                                                                                                                   
  data _null_;                                                                                                                                                                                                                                                                                                                       
    attrib returnCode      length=8;                                                                                                                                                                                                                                                                                                 
    attrib message         length=$200;                                                                                                                                                                                                                                                                                              
    attrib status          length=$70;                                                                                                                                                                                                                                                                                               
    attrib logMsgPrefix    length=$70;                                                                                                                                                                                                                                                                                               
    attrib logMsgPrimary   length=$70;                                                                                                                                                                                                                                                                                               
    attrib logMsg          length=$300;                                                                                                                                                                                                                                                                                              
                                                                                                                                                                                                                                                                                                                                     
    %***********************************;                                                                                                                                                                                                                                                                                            
    %* Declare the java objects        *;                                                                                                                                                                                                                                                                                            
    %***********************************;                                                                                                                                                                                                                                                                                            
    declare javaobj srv("com/sas/lsaf/macro/workflow/definition/ProcessDefinitionService");                                                                                                                                                                                                                                                              
    declare javaobj results("com/sas/lsaf/macro/common/result/Result");                                                                                                                                                                                                                                                                     
                                                                                                                                                                                                                                                                                                                                     
    %***********************************;                                                                                                                                                                                                                                                                                            
    %* Attempt the operation           *;                                                                                                                                                                                                                                                                                            
    %***********************************;                                                                                                                                                                                                                                                                                            
    srv.callStaticStringMethod("getProcessDefinitionStatus", "%bquote(&lsaf_processdefid)", results, status);                          
                                                                                                                                                                                                                                                                                                                                     
    %***********************************;                                                                                                                                                                                                                                                                                            
    %* Retrieve the results            *;                                                                                                                                                                                                                                                                                            
    %***********************************;                                                                                                                                                                                                                                                                                            
    results.callIntMethod("getReturnCode", returnCode);                                                                                                                                                                                                                                                                              
    results.callStringMethod("getReturnMessage", message);                                                                                                                                                                                                                                                                           
                                                                                                                                                                                                                                                                                                                                     
    %***********************************;                                                                                                                                                                                                                                                                                            
    %* Process the results             *;                                                                                                                                                                                                                                                                                            
    %***********************************; 
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    logMsgPrimary=logMsgPrefix;
    logMsg=" The status was returned for process flow definition: &lsaf_processdefid.." ;
    if (returnCode ne 0) then
    do;
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
      logMsg=" The status was not returned for process flow definition: &lsaf_processdefid..";
    end;
                                                                                                                                                                                                                                                                                                                                     
    %***********************************;                                                                                                                                                                                                                                                                                            
    %* Print messages in log           *;                                                                                                                                                                                                                                                                                            
    %***********************************;                                                                                                                                                                                                                                                                                            
    put;                                                                                                                                                                                                                                                                                                                             
    put logMsgPrimary " " logMsg;                                                                                                                                                                                                                                                                                                     
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));                                                                                                                                                                                                                                                                         
    put logMsgPrefix " _lsafMsg_= " message;                                                                                                                                                                                                                                                                                         
    put logMsgPrefix " _lsafRC_= " returnCode;                                                                                                                                                                                                                                                                                       
    put logMsgPrefix " _lsafProcessDefinitionStatus_= " status;                                                                                                                                                                                                                                                                                       
    put;                                                                                                                                                                                                                                                                                                                             
                                                                                                                                                                                                                                                                                                                                     
    %***********************************;                                                                                                                                                                                                                                                                                            
    %* Set the macro variables         *;                                                                                                                                                                                                                                                                                            
    %***********************************;                                                                                                                                                                                                                                                                                            
    call symputx("_lsafRC_", returnCode);                                                                                                                                                                                                                                                                                            
    call symputx("_lsafMsg_", message);  
    call symputx("_lsafProcessDefinitionStatus_", status);
                                                                                                                                                                                                                                                                                                                                     
  run;                                                                                                                                                                                                                                                                                                                               
                                                                                                                                                                                                                                                                                                                                     
%mend lsaf_getprocessdefinitionstatus;                                                                                                                                                                                                                                                                                                            