%* lsaf_getprocessdefelements                                                                      *;                                                                                                                                                                                                                                       
%*                                                                                                 *;                                                                                                                                                                                                                                       
%* Gets the elements of the specified process flow definition.                                     *;
%*                                                                                                 *;                                                                                                                                                                                                                                       
%* macrotype LSAF                                                                                  *;                                                                                                                                                                                                                                       
%* since 2.5                                                                                       *;                                                                                                                                                                                                                                       
%* exposure external                                                                               *;                                                                                                                                                                                                                                       
%*                                                                                                 *;                                                                                                                                                                                                                                       
%* History                                                                                         *;
%* 2021-05-25  Initial coding                                                                      *;
%* 2021-08-10  Remove header documentation                                                         *;
%* 2021-10-13  US11739                                                                             *;
%*                                                                                                 *;                                                                                                                                                                                                                                       
                                                                                                                                                                                                                                                                                                                                     
%macro lsaf_getprocessdefelements(
  lsaf_processdefid=,
  sas_dsname=work.lsafgetprocessdefelements
  ) /des='Gets the elements of a process flow definition within the SAS Life Science Analytics Framework.';                                                                                                                                                                                                                                                                                 
  
  %if "&sas_dsname" EQ "" %then %let sas_dsname=work.lsafgetprocessdefelements;
                                                                                                                                                                                                                                                                                                                                     
  %****************************************;                                                                                                                                                                                                                                                                                         
  %* Initialize macro variables           *;                                                                                                                                                                                                                                                                                         
  %****************************************;                                                                                                                                                                                                                                                                                         
  %lsaf_getproductname();                                                                                                                                                                                                                                                                                                            
                                                                                                                                                                                                                                                                                                                                     
  %global _lsafMsg_
          _lsafRC_
          _lsafRowCount_
  ;                                                                                                                                                                                                                                                                                                                                  
                                                                                                                                                                                                                                                                                                                                     
  %let _lsafRC_ =%str(-999);                                                                                                                                                                                                                                                                                                         
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);                                                                                                                                                                                                                                                

  %**********************************************;
  %* Start the datastep to call the java code   *;
  %**********************************************;
  data &sas_dsname (label="Created by &SYSMACRONAME"
                    keep=processDefID elementID elementName elementDescription elementType);
                    
    attrib returnCode             length=8
           message                length=$200
           logMsgPrefix           length=$70
           logMsgPrimary          length=$70
           logMsg                 length=$300
           rowCount               length=8

           processDefID           length=$256    label="Process Definition ID"
           elementID              length=$64     label="Element ID"
           elementName            length=$32     label="Element Name"
           elementDescription     length=$256    label="Element Description"
           elementType            length=$64     label="Element Type"
    ;

    rowCount=0;
                                                                                                                                                                                                                                                                                                                                     
    %***********************************;                                                                                                                                                                                                                                                                                            
    %* Declare the java objects        *;                                                                                                                                                                                                                                                                                            
    %***********************************;                                                                                                                                                                                                                                                                                            
    declare javaobj srv("com/sas/lsaf/macro/workflow/definition/ProcessDefinitionService");                                                                                                                                                                                                                                                              
    declare javaobj results("com/sas/lsaf/macro/workflow/definition/SasProcessDefinitionElementsResult");                                                                                                                                                                                                                                                                     
                                                                                                                                                                                                                                                                                                                                     
    %***********************************;                                                                                                                                                                                                                                                                                            
    %* Attempt the operation           *;                                                                                                                                                                                                                                                                                            
    %***********************************;                                                                                                                                                                                                                                                                                            
    srv.callStaticVoidMethod("getProcessDefinitionElements", "%bquote(&lsaf_processdefid)", results);                          
                                                                                                                                                                                                                                                                                                                                     
    %***********************************;                                                                                                                                                                                                                                                                                            
    %* Retrieve the results            *;                                                                                                                                                                                                                                                                                            
    %***********************************;                                                                                                                                                                                                                                                                                            
    results.callIntMethod("getReturnCode", returnCode);                                                                                                                                                                                                                                                                              
    results.callStringMethod("getReturnMessage", message);                                                                                                                                                                                                                                                                           
                                                                                                                                                                                                                                                                                                                                     
    %***********************************;                                                                                                                                                                                                                                                                                            
    %* Process the results             *;                                                                                                                                                                                                                                                                                            
    %***********************************; 
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    if (returnCode ne 0) then
    do;
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
      logMsg=" Cannot retrieve elements for process definition: &lsaf_processdefid.." ;
    end;
    else
    do;
      logMsgPrimary=logMsgPrefix;
      logMsg=" Elements were returned for the process definition: &lsaf_processdefid.." ;
      results.callIntMethod("getSize", rowCount);
      processDefID="&lsaf_processdefid";
      do row=0 to rowCount - 1;
        results.callStringMethod("getElementId", row, elementID);
        results.callStringMethod("getName", row, elementName);
        results.callStringMethod("getDescription", row, elementDescription);
        results.callStringMethod("getType", row, elementType);
        output;
      end;
    end;
    
    %***********************************;                                                                                                                                                                                                                                                                                            
    %* Print messages in log           *;                                                                                                                                                                                                                                                                                            
    %***********************************;                                                                                                                                                                                                                                                                                            
    put;                                                                                                                                                                                                                                                                                                                             
    put logMsgPrimary " " logMsg;                                                                                                                                                                                                                                                                                                     
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));                                                                                                                                                                                                                                                                         
    put logMsgPrefix " _lsafMsg_= " message;                                                                                                                                                                                                                                                                                         
    put logMsgPrefix " _lsafRC_= " returnCode;                                                                                                                                                                                                                                                                                       
    put;                                                                                                                                                                                                                                                                                                                             
                                                                                                                                                                                                                                                                                                                                     
    %***********************************;                                                                                                                                                                                                                                                                                            
    %* Set the macro variables         *;                                                                                                                                                                                                                                                                                            
    %***********************************;                                                                                                                                                                                                                                                                                            
    call symputx("_lsafRC_", returnCode);                                                                                                                                                                                                                                                                                            
    call symputx("_lsafMsg_", message);  
    call symputx("_lsafRowCount_", rowCount);
                                                                                                                                                                                                                                                                                                                                     
  run; 
  
  %***********************************;
  %* Sort the data set               *;
  %***********************************;
  %if (&_lsafRowCount_ > 0) %then
  %do;
    %let notesOption=%sysfunc(getoption(notes));
    options nonotes;
    proc sort data=&sas_dsname sortseq=linguistic(strength=primary);
      by elementID;
    run;
    options &notesOption;
  %end;

%mend lsaf_getprocessdefelements;                                                                                                                                                                                                                                                                                                            