%* lsaf_getprocessdefcontexts                                                                      *;                                                                                                                                                                                                                                       
%*                                                                                                 *;                                                                                                                                                                                                                                       
%* Gets the contexts in which the specified process flow definition is deployed. The metadata is   *;
%* stored in a SAS data set.                                                                       *;
%*                                                                                                 *;                                                                                                                                                                                                                                       
%* macrotype LSAF                                                                                  *;                                                                                                                                                                                                                                       
%* since 2.3                                                                                       *;                                                                                                                                                                                                                                       
%* exposure external                                                                               *;                                                                                                                                                                                                                                       
%*                                                                                                 *;                                                                                                                                                                                                                                       
%* History                                                                                         *;
%* 2020-02-18  Initial coding                                                                      *;
%* 2021-08-10  Remove header documentation                                                         *;
%* 2021-10-13  US11739                                                                             *;
%*                                                                                                 *;                                                                                                                                                                                                                                       
                                                                                                                                                                                                                                                                                                                                     
%macro lsaf_getprocessdefcontexts(
  lsaf_processdefid=,
  sas_dsname=work.lsafGetProcessDefContexts
  ) /des='Gets the contexts of a process flow definition within the SAS Life Science Analytics Framework.';                                                                                                                                                                                                                                                                                 
  
  %if "&sas_dsname" EQ "" %then %let sas_dsname=work.lsafGetProcessDefContexts;
                                                                                                                                                                                                                                                                                                                                     
  %****************************************;                                                                                                                                                                                                                                                                                         
  %* Initialize macro variables           *;                                                                                                                                                                                                                                                                                         
  %****************************************;                                                                                                                                                                                                                                                                                         
  %lsaf_getproductname();                                                                                                                                                                                                                                                                                                            
  
  %local _lsafRowCount_;
  
  %global _lsafMsg_
          _lsafRC_ 
  ;                                                                                                                                                                                                                                                                                                                                  
                                                                                                                                                                                                                                                                                                                                     
  %let _lsafRC_ =%str(-999);                                                                                                                                                                                                                                                                                                         
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);                                                                                                                                                                                                                                                
  %let _lsafRowCount_=0;
                                                                                                                                                                                                                                                                                                                                     
  %**********************************************;                                                                                                                                                                                                                                                                                   
  %* Start the datastep to call the java code   *;                                                                                                                                                                                                                                                                                   
  %**********************************************;                                                                                                                                                                                                                                                                                   

  %**********************************************;
  %* Start the datastep to call the java code   *;
  %**********************************************;
  data &sas_dsname (label="Created by &SYSMACRONAME"
                    keep=processDefID processDefName processDefDeployedVersion processDefContextType);
                    
    attrib returnCode             length=8
           message                length=$200
           logMsgPrefix           length=$70
           logMsgPrimary          length=$70
           logMsg                 length=$300
           rowCount               length=8

           processDefID              length=$256    label="Process Definition ID"
           processDefName            length=$64     label="Process Definition Name"
           processDefDeployedVersion length=$32     label="Process Definition Deployed Version"
           processDefContextType     length=$32     label="Process Definition Context Type"
    ;

    rowCount=0;
                                                                                                                                                                                                                                                                                                                                     
    %***********************************;                                                                                                                                                                                                                                                                                            
    %* Declare the java objects        *;                                                                                                                                                                                                                                                                                            
    %***********************************;                                                                                                                                                                                                                                                                                            
    declare javaobj srv("com/sas/lsaf/macro/workflow/definition/ProcessDefinitionService");                                                                                                                                                                                                                                                              
    declare javaobj results("com/sas/lsaf/macro/workflow/definition/SasProcessDefinitionContextsResult");                                                                                                                                                                                                                                                                     
                                                                                                                                                                                                                                                                                                                                     
    %***********************************;                                                                                                                                                                                                                                                                                            
    %* Attempt the operation           *;                                                                                                                                                                                                                                                                                            
    %***********************************;                                                                                                                                                                                                                                                                                            
    srv.callStaticVoidMethod("getProcessDefinitionContexts", "%bquote(&lsaf_processdefid)", results);                          
                                                                                                                                                                                                                                                                                                                                     
    %***********************************;                                                                                                                                                                                                                                                                                            
    %* Retrieve the results            *;                                                                                                                                                                                                                                                                                            
    %***********************************;                                                                                                                                                                                                                                                                                            
    results.callIntMethod("getReturnCode", returnCode);                                                                                                                                                                                                                                                                              
    results.callStringMethod("getReturnMessage", message);                                                                                                                                                                                                                                                                           
                                                                                                                                                                                                                                                                                                                                     
    %***********************************;                                                                                                                                                                                                                                                                                            
    %* Process the results             *;                                                                                                                                                                                                                                                                                            
    %***********************************; 
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    if (returnCode ne 0) then
    do;
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
      logMsg=" Cannot retrieve contexts for process definition: &lsaf_processdefid.." ;
    end;
    else
    do;
      logMsgPrimary=logMsgPrefix;
      logMsg=" Contexts were returned for the process definition: &lsaf_processdefid.." ;
      results.callIntMethod("getSize", rowCount);
      results.callStringMethod("getProcessDefinitionId", processDefID);
      results.callStringMethod("getProcessDefinitionName", processDefName);
      results.callStringMethod("getProcessDefinitionDeployedVersion", processDefDeployedVersion);
      do row=0 to rowCount - 1;
        results.callStringMethod("getContextType", row, processDefContextType);
        output;
      end;
    end;
    
    %***********************************;                                                                                                                                                                                                                                                                                            
    %* Print messages in log           *;                                                                                                                                                                                                                                                                                            
    %***********************************;                                                                                                                                                                                                                                                                                            
    put;                                                                                                                                                                                                                                                                                                                             
    put logMsgPrimary " " logMsg;                                                                                                                                                                                                                                                                                                     
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));                                                                                                                                                                                                                                                                         
    put logMsgPrefix " _lsafMsg_= " message;                                                                                                                                                                                                                                                                                         
    put logMsgPrefix " _lsafRC_= " returnCode;                                                                                                                                                                                                                                                                                       
    put;                                                                                                                                                                                                                                                                                                                             
                                                                                                                                                                                                                                                                                                                                     
    %***********************************;                                                                                                                                                                                                                                                                                            
    %* Set the macro variables         *;                                                                                                                                                                                                                                                                                            
    %***********************************;                                                                                                                                                                                                                                                                                            
    call symputx("_lsafRC_", returnCode);                                                                                                                                                                                                                                                                                            
    call symputx("_lsafMsg_", message);  
    call symputx("_lsafRowCount_", rowCount);
                                                                                                                                                                                                                                                                                                                                     
  run; 

  %***********************************;
  %* Sort the data set               *;
  %***********************************;
  %if (&_lsafRowCount_ > 0) %then
  %do;
    %let notesOption=%sysfunc(getoption(notes));
    options nonotes;
    proc sort data=&sas_dsname sortseq=linguistic(strength=primary);
      by processDefContextType;
    run;
    options &notesOption;
  %end;
                                                                                                                                                                                                                                                                                                                                     
%mend lsaf_getprocessdefcontexts;                                                                                                                                                                                                                                                                                                            