%* lsaf_getpfusertaskhistory                                                                       *;
%*                                                                                                 *;
%* Get the process flow user task history of a specific task.                                      *;
%*                                                                                                 *;
%* macrotype LSAF                                                                                  *;
%* since 2.5                                                                                       *;
%* exposure external                                                                               *;
%*                                                                                                 *;
%* History                                                                                         *;
%* 2021-02-24  original creation.                                                                  *;
%* 2021-08-12  Remove header documentation                                                         *;
%*                                                                                                 *;

%macro lsaf_getpfusertaskhistory(
  lsaf_taskid=,
  sas_dsname=work.lsafgetpfusertaskhistory
  ) /des='Get the process flow user task history of a specific task.';
  
  %if "&sas_dsname" EQ "" %then %let sas_dsname=work.lsafgetpfusertaskhistory;

  %****************************************;
  %* Initialize macro variables           *;
  %****************************************;
  %lsaf_getProductName();

  %global _lsafMsg_
          _lsafRC_
  ;

  %let _lsafRC_ =%str(-999);
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);


  %**********************************************;
  %* Start the datastep to call the java code   *;
  %**********************************************;
  data &sas_dsname (label="Created by &SYSMACRONAME"
                    keep=taskId elementID dateAssigned dateAssignedSASFormat assignee assigneeDisplayName dateStarted dateStartedSASFormat actualHours)
  ;
    attrib returnCode                length=8
           message                   length=$200
           logMsgPrefix              length=$70
           logMsgPrimary             length=$70
           logMsg                    length=$300
           rowCount                  length=8

           taskId                    length=$64  label="Task Identifier"
           elementID                 length=$256 label="Element Identifier"
           dateAssigned              length=$64  label="Date Task Assigned"
           dateAssignedSASFormat     length=$64  label="Date Task Assigned (SAS Format)"
           assignee                  length=$64  label="Assignee"
           assigneeDisplayName       length=$64  label="Assignee"
           dateStarted               length=$64  label="Date Task Started"
           dateStartedSASFormat      length=$64  label="Date Task Started (SAS Format)"
           actualHours               length=8    label="Assignee"
    ;

    rowCount=0;

    %***********************************;
    %* Declare the java objects        *;
    %***********************************;
    declare javaobj srv("com/sas/lsaf/macro/workflow/task/ProcessFlowTaskService") ;
    declare javaobj results("com/sas/lsaf/macro/workflow/task/SasTaskAssignmentHistoryResult");

    %***********************************;
    %* Attempt the operation           *;
    %***********************************;
    srv.callStaticVoidMethod("getUserTaskAssignmentHistory", "%bquote(&lsaf_taskid)", results) ;

    %***********************************;
    %* Retrieve the results            *;
    %***********************************;
    results.callIntMethod("getReturnCode", returnCode);
    results.callStringMethod("getReturnMessage", message);

    %***********************************;
    %* Process the results             *;
    %***********************************;
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    if (returnCode ne 0) then
    do;
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
      logMsg=" Cannot retrieve process flow user task history for task &lsaf_taskid.." ;
    end;
    else
    do;
      logMsgPrimary=logMsgPrefix;
      logMsg=" Process flow user task history ran successfully for task &lsaf_taskid.." ;
      results.callIntMethod("getSize", rowCount);
      taskId="&lsaf_taskid";
      do row=0 to rowCount - 1;
        results.callStringMethod("getElementId", row, elementID);
        results.callStringMethod("getDateAssigned", row, dateAssigned);
        results.callStringMethod("getSasFormattedDateAssigned", row, dateAssignedSASFormat);
        results.callStringMethod("getAssignee", row, assignee);
        results.callStringMethod("getAssigneeDisplayName", row, assigneeDisplayName);
        results.callStringMethod("getDateStarted", row, dateStarted);
        results.callStringMethod("getSasFormattedDateStarted", row, dateStartedSASFormat);
        results.callfloatMethod("getActualHours", row, actualHours);
        output;
      end;
    end;

    %***********************************;
    %* Print messages in log           *;
    %***********************************;
    put;
    put logMsgPrimary " " logMsg;
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));
    if (rowCount=0) 
      then put logMsgPrefix " No Process flow user task history was found.";
      else put logMsgPrefix " " rowCount " records written to data set &sas_dsname";
    put logMsgPrefix " _lsafMsg_= " message ;
    put logMsgPrefix " _lsafRC_= " returnCode ;
    put;

    %***********************************;
    %* Set the macro variables         *;
    %***********************************;
    call symputx("_lsafRC_", returnCode);
    call symputx("_lsafMsg_", message);

  run;

%mend lsaf_getpfusertaskhistory;
