%* lsaf_getparentmembershipcontext                                                               *;                                                                                                                                                                                                                                  
%*                                                                                               *;
%* Gets the nearest parent context with the membership capability for the specified path.        *; 
%*                                                                                               *;
%* macrotype LSAF                                                                                *;
%* since 2.1                                                                                     *;
%* exposure external                                                                             *;
%*                                                                                               *;
%* History                                                                                       *;
%* 2019-01-10  initial coding                                                                    *;
%* 2021-08-13  Remove header documentation                                                       *;
%*                                                                                               *;
                                                                                                                                                                                                                                                                                                                                     
%macro lsaf_getparentmembershipcontext(                                                                                                                                                                                                                                                                                                           
  lsaf_path=                                                                                                                                                                                                                                                                                                                         
  ) /des='Get the SAS Life Science Analytics Framework parent membership context for the specified path.';                                                                                                                                                                                                                                         
                                                                                                                                                                                                                                                                                                                                     
  %****************************************;                                                                                                                                                                                                                                                                                         
  %* Initialize macro variables           *;                                                                                                                                                                                                                                                                                         
  %****************************************;                                                                                                                                                                                                                                                                                         
  %lsaf_getProductName();                                                                                                                                                                                                                                                                                                            
                                                                                                                                                                                                                                                                                                                                     
  %global _lsafMsg_                                                                                                                                                                                                                                                                                                                  
          _lsafParentMembershipContext_                                                                                                                                                                                                                                                                                                           
          _lsafRC_                                                                                                                                                                                                                                                                                                                   
  ;                                                                                                                                                                                                                                                                                                                                  
                                                                                                                                                                                                                                                                                                                                     
  %let _lsafRC_ =%str(-999);                                                                                                                                                                                                                                                                                                         
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);                                                                                                                                                                                                                                                
                                                                                                                                                                                                                                                                                                                                     
  %**********************************************;                                                                                                                                                                                                                                                                                   
  %* Start the datastep to call the java code   *;                                                                                                                                                                                                                                                                                   
  %**********************************************;                                                                                                                                                                                                                                                                                   
  data _null_;                                                                                                                                                                                                                                                                                                                       
    attrib returnCode       length=8;                                                                                                                                                                                                                                                                                                 
    attrib message          length=$200;                                                                                                                                                                                                                                                                                              
    attrib logMsgPrefix     length=$70;                                                                                                                                                                                                                                                                                               
    attrib logMsgPrimary    length=$70;                                                                                                                                                                                                                                                                                               
    attrib logMsg           length=$300;                                                                                                                                                                                                                                                                                              
    attrib parentMembership length=$2048;                                                                                                                                                                                                                                                                                               
                                                                                                                                                                                                                                                                                                                                     
    %***********************************;                                                                                                                                                                                                                                                                                            
    %* Declare the java objects        *;                                                                                                                                                                                                                                                                                            
    %***********************************;                                                                                                                                                                                                                                                                                            
    declare javaobj srv("com/sas/lsaf/macro/content/repository/RepositoryService");                                                                                                                                                                                                                                                              
    declare javaobj results("com/sas/lsaf/macro/common/result/Result");                                                                                                                                                                                                                                                                     
                                                                                                                                                                                                                                                                                                                                     
    %***********************************;                                                                                                                                                                                                                                                                                            
    %* Attempt the operation           *;                                                                                                                                                                                                                                                                                            
    %***********************************;                                                                                                                                                                                                                                                                                            
    srv.callStaticStringMethod("getParentMembershipContext", "%bquote(&lsaf_path)", results, parentMembership);                                                                                                                                                                                                                                         
                                                                                                                                                                                                                                                                                                                                     
    %***********************************;                                                                                                                                                                                                                                                                                            
    %* Retrieve the results            *;                                                                                                                                                                                                                                                                                            
    %***********************************;                                                                                                                                                                                                                                                                                            
    results.callIntMethod("getReturnCode", returnCode);                                                                                                                                                                                                                                                                              
    results.callStringMethod("getReturnMessage", message);                                                                                                                                                                                                                                                                           
                                                                                                                                                                                                                                                                                                                                     
    %***********************************;                                                                                                                                                                                                                                                                                            
    %* Process the results             *;                                                                                                                                                                                                                                                                                            
    %***********************************;
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    if (returnCode ne 0) then                                                                                                                                                                                                                                                                                                        
    do;                                                                                                                                                                                                                                                                                                                              
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";                                                                                                                                                                                                                                                                       
      logMsg=" Could not determine the parent membership context: &lsaf_path." ;                                                                                                                                                                                                                                                                   
      parentMembership="";                                                                                                                                                                                                                                                                                                                 
    end;                                                                                                                                                                                                                                                                                                                             
    else                                                                                                                                                                                                                                                                                                                             
    do;
      logMsgPrimary=logMsgPrefix;                                                                                                                                                                                                                                                                           
      if parentMembership="" 
        then logMsg=" No parent membership context was found for path: &lsaf_path";
        else logMsg=" The parent membership context was returned for path: &lsaf_path";                                                                                                                                                                                                                                                                   
    end;                                                                                                                                                                                                                                                                                                                             
                                                                                                                                                                                                                                                                                                                                     
    %***********************************;                                                                                                                                                                                                                                                                                            
    %* Print messages in log           *;                                                                                                                                                                                                                                                                                            
    %***********************************;                                                                                                                                                                                                                                                                                            
    put;                                                                                                                                                                                                                                                                                                                             
    put logMsgPrimary logMsg;                                                                                                                                                                                                                                                                                                         
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));                                                                                                                                                                                                                                                                         
    put logMsgPrefix "_lsafMsg_=" message ;                                                                                                                                                                                                                                                                                          
    put logMsgPrefix "_lsafRC_=" returnCode ;                                                                                                                                                                                                                                                                                        
    put logMsgPrefix "_lsafParentMembershipContext_=" parentMembership ;                                                                                                                                                                                                                                                                                     
    put;                                                                                                                                                                                                                                                                                                                             
                                                                                                                                                                                                                                                                                                                                     
    %***********************************;                                                                                                                                                                                                                                                                                            
    %* Set the macro variables         *;                                                                                                                                                                                                                                                                                            
    %***********************************;                                                                                                                                                                                                                                                                                            
    call symputx("_lsafRC_", returnCode);                                                                                                                                                                                                                                                                                            
    call symputx("_lsafParentMembershipContext_", parentMembership) ;                                                                                                                                                                                                                                                                                   
    call symputx("_lsafMsg_", message);                                                                                                                                                                                                                                                                                              
                                                                                                                                                                                                                                                                                                                                     
  run;                                                                                                                                                                                                                                                                                                                               
                                                                                                                                                                                                                                                                                                                                     
%mend lsaf_getparentmembershipcontext;                                                                                                                                                                                                                                                                                                           
