%* lsaf_getowner                                                                                 *;
%*                                                                                               *;
%* Gets the current owner of an item within the SAS Life Science Analytics Framework             *;
%* repository.                                                                                   *;
%*                                                                                               *;
%* macrotype LSAF                                                                                *;
%* since 1.2                                                                                     *;
%* exposure external                                                                             *;
%*                                                                                               *;
%* History                                                                                       *;
%* 2013-08-30  updates for standardization and coding conventions                                *;
%* 2016-08-26  rebrand as LSAF                                                                   *;
%* 2019-02-05  update to 2.1                                                                     *;
%* 2020-07-13  update for refactor of java service hierarchy.                                    *;
%* 2021-08-05  Remove header documentation                                                       *;
%*                                                                                               *;

%macro lsaf_getowner(
  lsaf_path=,
  lsaf_aclType=
  ) /des='Get the owner of an item.';

  %****************************************;
  %* Initialize macro variables           *;
  %****************************************;
  %lsaf_getProductName();

  %global _lsafMsg_
          _lsafOwner_
          _lsafRC_
  ;

  %let _lsafRC_ =%str(-999);
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);

  %**********************************************;
  %* Start the datastep to call the java code   *;
  %**********************************************;
  data _null_;
    attrib returnCode      length=8;
    attrib message         length=$200;
    attrib logMsgPrefix    length=$70;
    attrib logMsgPrimary   length=$70;
    attrib logMsg          length=$300;
    attrib owner           length=$64;

    %***********************************;
    %* Declare the java objects        *;
    %***********************************;
    declare javaobj srv("com/sas/lsaf/macro/security/acl/AclService") ;
    declare javaobj results("com/sas/lsaf/macro/common/result/Result");

    %***********************************;
    %* Attempt the operation           *;
    %***********************************;
    srv.callStaticStringMethod("getOwner", "%bquote(&lsaf_path)", "%bquote(&lsaf_aclType)", results, owner);

    %***********************************;
    %* Retrieve the results            *;
    %***********************************;
    results.callIntMethod("getReturnCode", returnCode);
    results.callStringMethod("getReturnMessage", message);

    %***********************************;
    %* Process the results             *;
    %***********************************;
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    if (returnCode ne 0) then
    do;
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
      logMsg=" Cannot retrieve owner of the &lsaf_aclType ACL of &lsaf_path.." ;
    end;
    else
    do;
      logMsgPrimary=logMsgPrefix;
      logMsg=" The owner of the &lsaf_aclType ACL of &lsaf_path is " || owner ;
    end;

    %***********************************;
    %* Print messages in log           *;
    %***********************************;
    put;
    put logMsgPrimary " " logMsg;
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));
    put logMsgPrefix " _lsafMsg_= " message ;
    put logMsgPrefix " _lsafRC_= " returnCode ;
    put logMsgPrefix " _lsafOwner_= " owner;
    put;

    %***********************************;
    %* Set the macro variables         *;
    %***********************************;
    call symputx("_lsafRC_", returnCode);
    call symputx("_lsafMsg_", message);
    call symputx("_lsafOwner_", owner) ;

  run;

%mend lsaf_getowner;
