%* lsaf_getjobmanifestparameters                                                                   *;
%*                                                                                                 *;
%* Gets the metadata for the parameters for the specified job manifest in the repository. The      *;
%* metadata is stored in a SAS data set.                                                           *;
%*                                                                                                 *;
%* macrotype LSAF                                                                                  *;
%* since 2.3                                                                                       *;
%* exposure external                                                                               *;
%*                                                                                                 *;
%* History                                                                                         *;
%* 2019-11-13  initial coding.                                                                     *;
%* 2021-07-06  add lsaf_location parameter.                                                        *;
%* 2021-08-09  Remove header documentation                                                         *;
%*                                                                                                 *;

%macro lsaf_getjobmanifestparameters(
   lsaf_location=,
   lsaf_path=,
   lsaf_version=,
   sas_dsname=work.lsafGetJobManifestParameters
   ) /des='Get a list of the parameters for a job manifest.';

   %if "&sas_dsname" EQ "" %then %let sas_dsname=work.lsafGetJobManifestParameters;

   %****************************************;
   %* Initialize macro variables           *;
   %****************************************;
  %lsaf_getProductName();

   %global _lsafMsg_
           _lsafRC_
   ;

   %let _lsafRC_ =%str(-999);
   %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);

   %**********************************************;
   %* Start the datastep to call the java code   *;
   %**********************************************;
   data &sas_dsname (label="Created by &SYSMACRONAME"
                     keep=jobManifestLocation jobManifestPath jobManifestVersion jobLocation name type label value version includeSubfolders
   );
   attrib returnCode      length=8
          message         length=$200
          logMsgPrefix    length=$70
          logMsgPrimary   length=$70
          logMsg          length=$300
          rowCount        length=8

          jobManifestLocation length=$32       label="Job Manifest Source Location"
          jobManifestPath     length=$2048     label="Job Manifest Path"
          jobManifestVersion  length=$32       label="Job Manifest Version"
          jobLocation         length=$20       label="Job Source Location"
          name                length=$32       label="Parameter Name"
          type                length=$32       label="Parameter Type"
          label               length=$60       label="Parameter Label"
          value               length=$2048     label="Parameter Value"
          version             length=$10       label="Parameter File Version"
          includeSubfolders   length=$5        label="Include Subfolders"
   ;

   rowCount=0;

   %***********************************;
   %* Declare the java objects        *;
   %***********************************;
   declare javaobj srv("com/sas/lsaf/macro/execution/jobmanifest/JobManifestService") ;
   declare javaobj results("com/sas/lsaf/macro/execution/jobmanifest/SasManifestJobResult");

   %***********************************;
   %* Attempt the operation           *;
   %***********************************;
   srv.callStaticVoidMethod("getJobManifestParameters", "%bquote(&lsaf_location)", "%bquote(&lsaf_path)", "%bquote(&lsaf_version)", results) ;

   %***********************************;
   %* Retrieve the results            *;
   %***********************************;
   results.callIntMethod("getReturnCode", returnCode);
   results.callStringMethod("getReturnMessage", message);

   %***********************************;
   %* Process the results             *;
   %***********************************;
   logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
   if (returnCode ne 0) then
   do;
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
      if "&lsaf_version" NE ""
        then logMsg=" Cannot retrieve parameters for job manifest &lsaf_path, version &lsaf_version" ;
        else logMsg=" Cannot retrieve parameters for job manifest &lsaf_path" ;
   end;
   else
   do;
      logMsgPrimary=logMsgPrefix;
      logMsg=" Parameters were returned for job manifest &lsaf_path";
      results.callStringMethod("getManifestSourceLocation", jobManifestLocation);
      results.callStringMethod("getManifestPath", jobManifestPath);
      results.callStringMethod("getManifestVersion", jobManifestVersion);
      results.callIntMethod("getSize", rowCount);
      results.callStringMethod("getJobSourceLocation", jobLocation);
      do row=0 to rowCount - 1;
         results.callStringMethod("getName", row, name);
         results.callStringMethod("getType", row, type);
         results.callStringMethod("getLabel", row, label);
         results.callStringMethod("getParameterValue", row, value);
         results.callStringMethod("getFileVersion", row, version);
         results.callStringMethod("getContainerIncludeSubfolders", row, includeSubfolders);
         output;
      end;
   end;

   %***********************************;
   %* Print messages in log           *;
   %***********************************;
   put;
   put logMsgPrimary " " logMsg;
   put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));
   if (rowCount=0) 
     then put logMsgPrefix " No parameters were found.";
     else put logMsgPrefix " " rowCount " records written to data set &sas_dsname";
   put logMsgPrefix " _lsafMsg_= " message ;
   put logMsgPrefix " _lsafRC_= " returnCode ;
   put;

   %***********************************;
   %* Set the macro variables         *;
   %***********************************;
   call symputx("_lsafRC_", returnCode);
   call symputx("_lsafMsg_", message);

   run;

%mend lsaf_getjobmanifestparameters;