%* lsaf_getjobmanifestmetrics                                                                      *;
%*                                                                                                 *;
%* macrotype LSAF                                                                                  *;
%* since 2.3                                                                                       *;
%* exposure external                                                                               *;
%*                                                                                                 *;
%* History                                                                                         *;
%* 2019-11-08  initial coding.                                                                     *;
%* 2021-07-06  add lsaf_location parameter.                                                        *;
%* 2021-08-09  Remove header documentation                                                         *;
%*                                                                                                 *;

%macro lsaf_getjobmanifestmetrics(
   lsaf_location=,
   lsaf_path=,
   lsaf_version=,
   sas_dsname=work.lsafgetjobmanifestmetrics
   ) /des='Get the metrics for a job manifest.';

   %if "&sas_dsname" EQ "" %then %let sas_dsname=work.lsafgetjobmanifestmetrics;

   %****************************************;
   %* Initialize macro variables           *;
   %****************************************;
   %lsaf_getProductName();

   %global _lsafMsg_
           _lsafRC_
   ;

   %let _lsafRC_ =%str(-999);
   %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);

   %**********************************************;
   %* Start the datastep to call the java code   *;
   %**********************************************;
   data &sas_dsname (label="Created by &SYSMACRONAME"
                     keep=jobManifestLocation jobManifestPath jobManifestVersion type total size formattedsize time formattedtime
   );
   attrib returnCode      length=8
          message         length=$200
          logMsgPrefix    length=$70
          logMsgPrimary   length=$70
          logMsg          length=$300
          rowCount        length=8

          jobManifestLocation length=$32       label="Job Manifest Source Location"
          jobManifestPath     length=$2048     label="Job Manifest Path"
          jobManifestVersion  length=$32       label="Job Manifest Version"
          type                length=$2048     label="Type"
          total               length=8         label="Total"
          size                length=8         label="Size (Bytes)"
          formattedsize       length=$20       label="Size (Formatted)"
          time                length=8         label="Time (Microseconds)"
          formattedtime       length=$20       label="Time (h:m:s:ms)"
   ;

   rowCount=0;

   %***********************************;
   %* Declare the java objects        *;
   %***********************************;
   declare javaobj srv("com/sas/lsaf/macro/execution/jobmanifest/JobManifestService") ;
   declare javaobj results("com/sas/lsaf/macro/execution/jobmanifest/SasManifestMetricsResult");

   %***********************************;
   %* Attempt the operation           *;
   %***********************************;
   srv.callStaticVoidMethod("getJobManifestMetricsByPath", "%bquote(&lsaf_location)", "%bquote(&lsaf_path)", "%bquote(&lsaf_version)", results) ;

   %***********************************;
   %* Retrieve the results            *;
   %***********************************;
   results.callIntMethod("getReturnCode", returnCode);
   results.callStringMethod("getReturnMessage", message);

   %***********************************;
   %* Process the results             *;
   %***********************************;
   logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
   if (returnCode ne 0) then
   do;
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
      if "&lsaf_version" NE ""
        then logMsg=" Cannot retrieve metrics for job manifest &lsaf_path, version &lsaf_version" ;
        else logMsg=" Cannot retrieve metrics for job manifest &lsaf_path" ;
   end;
   else
   do;
      logMsgPrimary=logMsgPrefix;
      logMsg=" Metrics were returned for job manifest &lsaf_path" ;
      results.callStringMethod("getManifestSourceLocation", jobManifestLocation);
      results.callStringMethod("getManifestPath", jobManifestPath);
      results.callStringMethod("getManifestVersion", jobManifestVersion);
      results.callIntMethod("getSize", rowCount);
      do row=0 to rowCount - 1;
         results.callStringMethod("getMetricType", row, type);
         results.callIntMethod("getMetricTotal", row, total);
         if total lt 0 then total=.;
         results.callLongMethod("getMetricSize", row, size);
         results.callStringMethod("getMetricFormattedSize", row, formattedsize);
         if size lt 0 then size=.;
         results.callLongMethod("getMetricTime", row, time);
         if time lt 0 then time=.;
         results.callStringMethod("getMetricFormattedTime", row, formattedtime);
         output;
      end;
   end;

   %***********************************;
   %* Print messages in log           *;
   %***********************************;
   put;
   put logMsgPrimary " " logMsg;
   put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));
   if (rowCount=0) 
     then put logMsgPrefix " No metrics were found.";
     else put logMsgPrefix " " rowCount " records written to data set &sas_dsname";
   put logMsgPrefix " _lsafMsg_= " message ;
   put logMsgPrefix " _lsafRC_= " returnCode ;
   put;

   %***********************************;
   %* Set the macro variables         *;
   %***********************************;
   call symputx("_lsafRC_", returnCode);
   call symputx("_lsafMsg_", message);

   run;

%mend lsaf_getjobmanifestmetrics;