%* lsaf_getdefsmappedforautoflow                                                                   *;                                                                                                                                                                                                                                       
%*                                                                                                 *;                                                                                                                                                                                                                                       
%* Gets the process flow definitions mapped for autoflow.                                          *;
%*                                                                                                 *;                                                                                                                                                                                                                                       
%* macrotype LSAF                                                                                  *;                                                                                                                                                                                                                                       
%* since 2.5                                                                                       *;                                                                                                                                                                                                                                       
%* exposure external                                                                               *;                                                                                                                                                                                                                                       
%*                                                                                                 *;                                                                                                                                                                                                                                       
%* History                                                                                         *;
%* 2021-05-26  Initial coding                                                                      *;
%* 2021-07-13  updated for new service name                                                        *;
%* 2021-08-10  Remove header documentation                                                         *;
%*                                                                                                 *;                                                                                                                                                                                                                                       
                                                                                                                                                                                                                                                                                                                                     
%macro lsaf_getdefsmappedforautoflow(
  lsaf_contexttypeid=,
  lsaf_autoflowtype=,
  lsaf_activeonly=,
  sas_dsname=work.lsafgetdefsmappedforautoflow
  ) /des='Gets the process definitions mapped for autoflow within the SAS Life Science Analytics Framework.';                                                                                                                                                                                                                                                                                 
  
  %if "&sas_dsname" EQ "" %then %let sas_dsname=work.lsafgetdefsmappedforautoflow;
                                                                                                                                                                                                                                                                                                                                     
  %****************************************;                                                                                                                                                                                                                                                                                         
  %* Initialize macro variables           *;                                                                                                                                                                                                                                                                                         
  %****************************************;                                                                                                                                                                                                                                                                                         
  %lsaf_getproductname();                                                                                                                                                                                                                                                                                                            
                                                                                                                                                                                                                                                                                                                                     
  %global _lsafMsg_
          _lsafRC_ 
  ;                                                                                                                                                                                                                                                                                                                                  
                                                                                                                                                                                                                                                                                                                                     
  %let _lsafRC_ =%str(-999);                                                                                                                                                                                                                                                                                                         
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);                                                                                                                                                                                                                                                

  %**********************************************;
  %* Start the datastep to call the java code   *;
  %**********************************************;
  data &sas_dsname (label="Created by &SYSMACRONAME"
                    keep=defID name description deployedVersion sourceFilePath sourceFileVersion contexts status comment);
                    
    attrib returnCode             length=8
           message                length=$200
           logMsgPrefix           length=$70
           logMsgPrimary          length=$70
           logMsg                 length=$300
           rowCount               length=8

           defID               length=$256   label="Process Flow Definition ID"
           name                length=$256   label="Process Flow Definition Name"
           description         length=$1024  label="Process Flow Definition Description"
           deployedVersion     length=$32    label="Process Flow Definition Version"
           sourceFilePath      length=$2048  label="Source file path"
           sourceFileVersion   length=$32    label="Source file version number"
           contexts            length=$2048  label="Contexts where definition is deployed"
           status	       length=$64    label="Status"
           comment             length=$1024  label="Comment"
    ;
   
    rowCount=0;
                                                                                                                                                                                                                                                                                                                                     
    %***********************************;                                                                                                                                                                                                                                                                                            
    %* Declare the java objects        *;                                                                                                                                                                                                                                                                                            
    %***********************************;                                                                                                                                                                                                                                                                                            
    declare javaobj srv("com/sas/lsaf/macro/workflow/definition/mapping/ProcessDefinitionMappingService");
    declare javaobj results("com/sas/lsaf/macro/workflow/definition/SasProcessDefinitionInfosResult");                                                                                                                                                                                                                                                                     
                                                                                                                                                                                                                                                                                                                                     
    %***********************************;                                                                                                                                                                                                                                                                                            
    %* Attempt the operation           *;                                                                                                                                                                                                                                                                                            
    %***********************************;                                                                                                                                                                                                                                                                                            
    srv.callStaticVoidMethod("getProcessDefinitionsMappedForAutoFlow", "%bquote(&lsaf_contexttypeid)", "%bquote(&lsaf_autoflowtype)", "%bquote(&lsaf_activeonly)", results);                          
                                                                                                                                                                                                                                                                                                                                     
    %***********************************;                                                                                                                                                                                                                                                                                            
    %* Retrieve the results            *;                                                                                                                                                                                                                                                                                            
    %***********************************;                                                                                                                                                                                                                                                                                            
    results.callIntMethod("getReturnCode", returnCode);                                                                                                                                                                                                                                                                              
    results.callStringMethod("getReturnMessage", message);                                                                                                                                                                                                                                                                           
                                                                                                                                                                                                                                                                                                                                     
    %***********************************;                                                                                                                                                                                                                                                                                            
    %* Process the results             *;                                                                                                                                                                                                                                                                                            
    %***********************************; 
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    if (returnCode ne 0) then
    do;
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
      if "&lsaf_contexttypeid." eq "" then logMsg=" Cannot get autoflow process definition mappings for all context types.";
        else logMsg=" Cannot get autoflow process definition mappings for &lsaf_contexttypeid.." ;
    end;
    else
    do;
      logMsgPrimary=logMsgPrefix;
      if "&lsaf_contexttypeid." eq "" then logMsg=" Autoflow process definition mappings were returned for all context types."; 
        else logMsg=" Autoflow process definition mappings were returned for &lsaf_contexttypeid..";
      results.callIntMethod("getSize", rowCount);
      do row=0 to rowCount - 1;
        results.callStringMethod("getId", row, defID);
        results.callStringMethod("getName", row, name);
        results.callStringMethod("getDescription", row, description);
        results.callStringMethod("getDeployedVersion", row, deployedVersion);
        results.callStringMethod("getDefinitionFilePath", row, sourceFilePath);
        results.callStringMethod("getDefinitionFileVersion", row, sourceFileVersion);
        results.callStringMethod("getContextTypes", row, contexts);
        results.callStringMethod("getStatus", row, status);
        results.callStringMethod("getComment", row, comment);
        output;
      end;
    end;
    
    %***********************************;                                                                                                                                                                                                                                                                                            
    %* Print messages in log           *;                                                                                                                                                                                                                                                                                            
    %***********************************;                                                                                                                                                                                                                                                                                            
    put;                                                                                                                                                                                                                                                                                                                             
    put logMsgPrimary " " logMsg;                                                                                                                                                                                                                                                                                                     
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));                                                                                                                                                                                                                                                                         
    put logMsgPrefix " _lsafMsg_= " message;                                                                                                                                                                                                                                                                                         
    put logMsgPrefix " _lsafRC_= " returnCode;                                                                                                                                                                                                                                                                                       
    put;                                                                                                                                                                                                                                                                                                                             
                                                                                                                                                                                                                                                                                                                                     
    %***********************************;                                                                                                                                                                                                                                                                                            
    %* Set the macro variables         *;                                                                                                                                                                                                                                                                                            
    %***********************************;                                                                                                                                                                                                                                                                                            
    call symputx("_lsafRC_", returnCode);                                                                                                                                                                                                                                                                                            
    call symputx("_lsafMsg_", message);  
                                                                                                                                                                                                                                                                                                                                     
  run; 
                                                                                                                                                                                                                                                                                                                                     
%mend lsaf_getdefsmappedforautoflow;                                                                                                                                                                                                                                                                                                            
