%* lsaf_getdefinitionmappings                                                                      *;                                                                                                                                                                                                                                       
%*                                                                                                 *;                                                                                                                                                                                                                                       
%* Gets the process flow definition mappings.                                                      *;
%*                                                                                                 *;                                                                                                                                                                                                                                       
%* macrotype LSAF                                                                                  *;                                                                                                                                                                                                                                       
%* since 2.5                                                                                       *;                                                                                                                                                                                                                                       
%* exposure external                                                                               *;                                                                                                                                                                                                                                       
%*                                                                                                 *;                                                                                                                                                                                                                                       
%* History                                                                                         *;
%* 2021-05-26  Initial coding                                                                      *;
%* 2021-07-13  updated for new service name                                                        *;
%* 2021-08-10  Remove header documentation                                                         *;
%*                                                                                                 *;                                                                                                                                                                                                                                       
                                                                                                                                                                                                                                                                                                                                     
%macro lsaf_getdefinitionmappings(
  lsaf_processdefid=,
  lsaf_elementid=,
  lsaf_autoflowtype=,
  sas_dsname=work.lsafgetdefinitionmappings
  ) /des='Gets the process definitions mappings within the SAS Life Science Analytics Framework.';                                                                                                                                                                                                                                                                                 
  
  %if "&sas_dsname" EQ "" %then %let sas_dsname=work.lsafgetdefinitionmappings;
                                                                                                                                                                                                                                                                                                                                     
  %****************************************;                                                                                                                                                                                                                                                                                         
  %* Initialize macro variables           *;                                                                                                                                                                                                                                                                                         
  %****************************************;                                                                                                                                                                                                                                                                                         
  %lsaf_getproductname();                                                                                                                                                                                                                                                                                                            
                                                                                                                                                                                                                                                                                                                                     
  %global _lsafMsg_
          _lsafRC_ 
  ;                                                                                                                                                                                                                                                                                                                                  
                                                                                                                                                                                                                                                                                                                                     
  %let _lsafRC_ =%str(-999);                                                                                                                                                                                                                                                                                                         
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);                                                                                                                                                                                                                                                

  %**********************************************;
  %* Start the datastep to call the java code   *;
  %**********************************************;
  data &sas_dsname (label="Created by &SYSMACRONAME"
                    keep=defID elementId elementAttrName elementAttrDisplayName elementAttrType elementAttrIsMultivalued mappingName
                         mappingType mappingIsDerived isMapped);
                    
    attrib returnCode             length=8
           message                length=$200
           logMsgPrefix           length=$70
           logMsgPrimary          length=$70
           logMsg                 length=$300
           rowCount               length=8

           defID                      length=$256   label="Process Flow Definition ID"
           elementId                  length=$256   label="Process Definition Element ID"
           elementAttrName            length=$64    label="Element Attribute Name"
           elementAttrDisplayName     length=$64    label="Element Attribute Display Name"
           elementAttrType            length=$32    label="Element Attribute Type"
           elementAttrIsMultivalued   length=8      label="Element Attribute Allows Multiple Mappings"
           mappingName                length=$256   label="Mapping Name Associated with Element Attribute"
           mappingType                length=$32    label="Mapping Type Associated with Element Attribute"
           mappingIsDerived	      length=8      label="Mapping Derived?"
           isMapped                   length=8      label="Is Element Attribute Mapped?"
    ;
    
    rowCount=0;
                                                                                                                                                                                                                                                                                                                                     
    %***********************************;                                                                                                                                                                                                                                                                                            
    %* Declare the java objects        *;                                                                                                                                                                                                                                                                                            
    %***********************************;                                                                                                                                                                                                                                                                                            
    declare javaobj srv("com/sas/lsaf/macro/workflow/definition/mapping/ProcessDefinitionMappingService");
    declare javaobj results("com/sas/lsaf/macro/workflow/definition/mapping/SasDefElementMappingsResult");                                                                                                                                                                                                                                                                     
                                                                                                                                                                                                                                                                                                                                     
    %***********************************;                                                                                                                                                                                                                                                                                            
    %* Attempt the operation           *;                                                                                                                                                                                                                                                                                            
    %***********************************;                                                                                                                                                                                                                                                                                            
    srv.callStaticVoidMethod("getProcessDefinitionMappings", "%bquote(&lsaf_processdefid)", "%bquote(&lsaf_elementid)", 
                             "%bquote(&lsaf_autoflowtype)", results);                          
                                                                                                                                                                                                                                                                                                                                     
    %***********************************;                                                                                                                                                                                                                                                                                            
    %* Retrieve the results            *;                                                                                                                                                                                                                                                                                            
    %***********************************;                                                                                                                                                                                                                                                                                            
    results.callIntMethod("getReturnCode", returnCode);                                                                                                                                                                                                                                                                              
    results.callStringMethod("getReturnMessage", message);                                                                                                                                                                                                                                                                           
                                                                                                                                                                                                                                                                                                                                     
    %***********************************;                                                                                                                                                                                                                                                                                            
    %* Process the results             *;                                                                                                                                                                                                                                                                                            
    %***********************************; 
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    if (returnCode ne 0) then
    do;
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
      logMsg=" Cannot get process definition mappings for &lsaf_processdefid.." ;
    end;
    else
    do;
      logMsgPrimary=logMsgPrefix;
      logMsg=" Process definition mappings were returned for &lsaf_processdefid.." ;
      results.callIntMethod("getSize", rowCount);
      defId="&lsaf_processdefid";
      do row=0 to rowCount - 1;
        results.callStringMethod("getElementId", row, elementId);
        results.callStringMethod("getAttributeName", row, elementAttrName);
        results.callStringMethod("getAttributeDisplayName", row, elementAttrDisplayName);
        results.callStringMethod("getAttributeType", row, elementAttrType);
        results.callBooleanMethod("attributeIsMultiValued", row, elementAttrIsMultivalued);
        results.callStringMethod("getAutoFlowMapAttrName", row, mappingName);
        results.callStringMethod("getAutoFlowMapAttrType", row, mappingType);
        results.callBooleanMethod("autoFlowMapAttrIsDerived", row, mappingIsDerived);
        results.callBooleanMethod("attributeIsMapped", row, isMapped);
        output;
      end;
    end;
    
    %***********************************;                                                                                                                                                                                                                                                                                            
    %* Print messages in log           *;                                                                                                                                                                                                                                                                                            
    %***********************************;                                                                                                                                                                                                                                                                                            
    put;                                                                                                                                                                                                                                                                                                                             
    put logMsgPrimary " " logMsg;                                                                                                                                                                                                                                                                                                     
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));                                                                                                                                                                                                                                                                         
    put logMsgPrefix " _lsafMsg_= " message;                                                                                                                                                                                                                                                                                         
    put logMsgPrefix " _lsafRC_= " returnCode;                                                                                                                                                                                                                                                                                       
    put;                                                                                                                                                                                                                                                                                                                             
                                                                                                                                                                                                                                                                                                                                     
    %***********************************;                                                                                                                                                                                                                                                                                            
    %* Set the macro variables         *;                                                                                                                                                                                                                                                                                            
    %***********************************;                                                                                                                                                                                                                                                                                            
    call symputx("_lsafRC_", returnCode);                                                                                                                                                                                                                                                                                            
    call symputx("_lsafMsg_", message);  
                                                                                                                                                                                                                                                                                                                                     
  run; 
                                                                                                                                                                                                                                                                                                                                     
%mend lsaf_getdefinitionmappings;                                                                                                                                                                                                                                                                                                            
