%* lsaf_getapiversions                                                                            *;
%*                                                                                                *;
%* Writes to the SAS log file the current version numbers for the SAS Life Science Analytics      *;
%* Framework API Client and the SAS macros.                                                       *;
%*                                                                                                *;
%* macrotype LSAF                                                                                 *;
%* since 1.3                                                                                      *;
%* exposure external                                                                              *;
%*                                                                                                *;
%* History                                                                                        *;
%* 2013-08-30  updates for standardization and coding conventions                                 *;
%* 2014-04-04  changed exposure to external                                                       *;
%* 2016-08-26  rebrand as LSAF                                                                    *;
%* 2019-03-13  update to 2.1                                                                      *;
%* 2019-04-01  renamed from lsaf_getconfiguration to lsaf_getapiversions                          *;
%* 2020-07-13  update for refactor of java service hierarchy.                                     *;
%* 2021-08-17  Remove header documentation                                                        *;
%* 2022-03-22  DE17654 - Addition for 2.6.1a label. NEEDS TO BE REMOVED IN THE FUTURE.            *;
%* 2024-07-26  DE17654 - 2.7: Removed note added for 2.6.1.                                       *;
%*                                                                                                *;

%macro lsaf_getapiversions(
   )/des='Get SAS Life Science Analytics Framework Macro version information.';

  %****************************************;
  %* Initialize macro variables           *;
  %****************************************;
  %lsaf_getproductname();

  %global _lsafMsg_
          _lsafRC_
  ;

  %let _lsafRC_ =%str(-999);
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);

  %**********************************************;
  %* Start the datastep to call the java code   *;
  %**********************************************;
  data _null_;
    attrib returnCode      length=8;
    attrib message         length=$200;
    attrib logMsgPrefix    length=$70;
    attrib logMsgPrimary   length=$70;
    attrib logMsg          length=$300;
    attrib rowCount        length=8;

    attrib name            length=$128     label="Property Name";
    attrib value           length=$512     label="Property Value";

    %***********************************;
    %* Declare the java objects        *;
    %***********************************;
    declare javaobj srv("com/sas/lsaf/macro/core/system/SystemService");
    declare javaobj results("com/sas/lsaf/macro/common/result/SasPropertiesResult");

    %***********************************;
    %* Attempt the operation           *;
    %***********************************;
    srv.callStaticVoidMethod("getApiVersions", results);

    %***********************************;
    %* Retrieve the results            *;
    %***********************************;
    results.callIntMethod("getReturnCode", returnCode);
    results.callStringMethod("getReturnMessage", message);

    %***********************************;
    %* Process the results             *;
    %***********************************;
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    if (returnCode ne 0) then
    do;
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro: ";
      logMsg="Could not retrieve version information." ;
    end;
    else
    do;
      logMsgPrimary=logMsgPrefix;
      logMsg="Version information was returned." ;
    end;

    %***********************************;
    %* Print messages in log           *;
    %***********************************;
    put;
    put logMsgPrimary logMsg;
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));
    put logMsgPrefix "_lsafMsg_=" message ;
    put logMsgPrefix "_lsafRC_=" returnCode ;
    put;

    results.callIntMethod("getSize", rowCount);
    do row=0 to rowCount - 1;
      results.callStringMethod("getPropertyName", row, name);
      results.callStringMethod("getPropertyValue", row, value);
      put name ": " value;
    end;

    %***********************************;
    %* Set the macro variables         *;
    %***********************************;
    call symputx("_lsafRC_", returnCode);
    call symputx("_lsafMsg_", message);

  run;

%mend lsaf_getapiversions;
