%* lsaf_existsinworkspace                                                                   *;
%*                                                                                          *;
%* Indicates whether an item exists in the workspace of the current user.                   *;
%*                                                                                          *;
%* macrotype LSAF                                                                           *;
%* since 1.5                                                                                *;
%* exposure external                                                                        *;
%*                                                                                          *;
%* History                                                                                  *;
%* 2016-09-23  original coding                                                              *;
%* 2019-01-09  renamed lsaf_workspaceobjectexists to lsaf_existsinworkspace                 *;
%* 2020-07-13  update for refactor of java service hierarchy.                               *;
%* 2021-08-18  Remove header documentation                                                  *;
%*                                                                                          *;

%macro lsaf_existsinworkspace(
  lsaf_path=
  ) /des='Does the item exist in the workspace?';

  %****************************************;
  %* Initialize macro variables           *;
  %****************************************;
  %lsaf_getproductname();

  %global _lsafMsg_
          _lsafExistsInWorkspace_
          _lsafRC_
  ;

  %let _lsafRC_ =%str(-999);
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);

  %**********************************************;
  %* Start the datastep to call the java code   *;
  %**********************************************;
  data _null_;
    attrib returnCode      length=8;
    attrib message         length=$200;
    attrib logMsgPrefix    length=$70;
    attrib logMsgPrimary   length=$70;
    attrib logMsg          length=$300;
    attrib exists          length=3;

    %***********************************;
    %* Declare the java objects        *;
    %***********************************;
    declare javaobj srv("com/sas/lsaf/macro/content/workspace/WorkspaceService");
    declare javaobj results("com/sas/lsaf/macro/common/result/Result");

    %***********************************;
    %* Attempt the operation           *;
    %***********************************;
    srv.callStaticBooleanMethod("exists", "%bquote(&lsaf_path)", results, exists);

    %***********************************;
    %* Retrieve the results            *;
    %***********************************;
    results.callIntMethod("getReturnCode", returnCode);
    results.callStringMethod("getReturnMessage", message);

    %***********************************;
    %* Process the results             *;
    %***********************************;
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    if (returnCode ne 0) then
    do;
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
      logMsg=" Cannot determine if the item exists in the workspace: &lsaf_path." ;
      exists=-1;
    end;
    else
    do;
      logMsgPrimary=logMsgPrefix;
      if (exists) 
        then logMsg=" The item exists in the workspace: &lsaf_path.";
        else logMsg=" The item does not exist in the workspace: &lsaf_path." ;
    end;

    %***********************************;
    %* Print messages in log           *;
    %***********************************;
    put;
    put logMsgPrimary " " logMsg;
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));
    put logMsgPrefix " _lsafMsg_= " message;
    put logMsgPrefix " _lsafRC_= " returnCode;
    put logMsgPrefix " _lsafExistsInWorkspace_= " exists;
    put;

    %***********************************;
    %* Set the macro variables         *;
    %***********************************;
    call symputx("_lsafRC_", returnCode);
    call symputx("_lsafMsg_", message);
    call symputx("_lsafExistsInWorkspace_", exists) ;

  run;

%mend lsaf_existsinworkspace;
