%* lsaf_exists                                                                              *;
%*                                                                                          *;
%* Indicates whether a repository item exists.                                              *;
%*                                                                                          *;
%* macrotype LSAF                                                                           *;
%* since 1.1                                                                                *;
%* exposure external                                                                        *;
%*                                                                                          *;
%* History                                                                                  *;
%* 2013-08-30  updates for standardization and coding conventions                           *;
%* 2016-08-26  rebrand as LSAF                                                              *;
%* 2018-12-10  documentation update                                                         *;
%* 2018-12-10  documentation update for LSAF 5.x behavior                                   *;
%* 2019-01-08  renamed lsaf_objectexists to lsaf_exists                                     *;
%* 2021-08-13  Remove header documentation                                                  *;
%*                                                                                          *;

%macro lsaf_exists(
  lsaf_path=
  ) /des='Does the item exist in the repository?';

  %****************************************;
  %* Initialize macro variables           *;
  %****************************************;
  %lsaf_getproductname();

  %global _lsafMsg_
          _lsafExists_
          _lsafRC_
  ;

  %let _lsafRC_ =%str(-999);
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);

  %**********************************************;
  %* Start the datastep to call the java code   *;
  %**********************************************;
  data _null_;
    attrib returnCode      length=8;
    attrib message         length=$200;
    attrib logMsgPrefix    length=$70;
    attrib logMsg          length=$300;
    attrib exists          length=3;
    attrib logMsgPrimary   length=$70;

    %***********************************;
    %* Declare the java objects        *;
    %***********************************;
    declare javaobj srv("com/sas/lsaf/macro/content/repository/RepositoryService");
    declare javaobj results("com/sas/lsaf/macro/common/result/Result");

    %***********************************;
    %* Attempt the operation           *;
    %***********************************;
    srv.callStaticBooleanMethod("exists", "%bquote(&lsaf_path)", results, exists);

    %***********************************;
    %* Retrieve the results            *;
    %***********************************;
    results.callIntMethod("getReturnCode", returnCode);
    results.callStringMethod("getReturnMessage", message);

    %***********************************;
    %* Process the results             *;
    %***********************************;
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    if (returnCode ne 0) then
    do;
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
      logMsg=" Cannot determine if the item exists: &lsaf_path." ;
      exists=-1;
    end;
    else
    do;
      logMsgPrimary=logMsgPrefix;
      if (exists) then
      do;
        logMsg=" The item exists: &lsaf_path." ;
      end;
      else
      do;
        logMsg=" The item does not exist: &lsaf_path." ;
      end;
    end;

    %***********************************;
    %* Print messages in log           *;
    %***********************************;
    put;
    put logMsgPrimary " " logMsg;
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));
    put logMsgPrefix " _lsafMsg_= " message;
    put logMsgPrefix " _lsafRC_= " returnCode;
    put logMsgPrefix " _lsafExists_= " exists;
    put;

    %***********************************;
    %* Set the macro variables         *;
    %***********************************;
    call symputx("_lsafRC_", returnCode);
    call symputx("_lsafMsg_", message);
    call symputx("_lsafExists_", exists) ;

  run;

%mend lsaf_exists ;
