%* lsaf_downloadfile                                                                                 *;
%*                                                                                                   *;
%* Downloads a file to a local computer from the repository.                                         *;
%*                                                                                                   *;
%* macrotype LSAF                                                                                    *;
%* since 1.3                                                                                         *;
%* exposure external                                                                                 *;
%*                                                                                                   *;
%* History                                                                                           *;
%* 2013-10-30  initial coding                                                                        *;
%* 2016-08-26  rebrand as LSAF                                                                       *;
%* 2019-02-16  Update to 2.1                                                                         *;
%* 2021-08-13  Remove header documentation                                                           *;
%*                                                                                                   *;

%macro lsaf_downloadfile(
  lsaf_path=,
  lsaf_version=,
  local_path=
  ) /des='Download a file to your local computer from the SAS Life Science Analytics Framework repository.';

  %****************************************;
  %* Initialize macro variables           *;
  %****************************************;
  %lsaf_getProductName();

  %global _lsafMsg_
          _lsafRC_
  ;

  %let _lsafRC_=%str(-999);
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);

  %**********************************************;
  %* Start the datastep to call the java code   *;
  %**********************************************;
  data _null_;
    attrib returnCode      length=8;
    attrib message         length=$200;
    attrib logMsgPrefix    length=$70;
    attrib logMsg          length=$300;
    attrib logMsgPrimary   length=$70;

    %***********************************;
    %* Declare the java objects        *;
    %***********************************;
    declare javaobj srv("com/sas/lsaf/macro/content/repository/RepositoryService");
    declare javaobj results("com/sas/lsaf/macro/common/result/Result");

    %***********************************;
    %* Attempt the operation           *;
    %***********************************;
    srv.callStaticVoidMethod("downloadFile", "%bquote(&lsaf_path)", "%bquote(&lsaf_version)", "%bquote(&local_path)", results);

    %***********************************;
    %* Retrieve the results            *;
    %***********************************;
    results.callIntMethod("getReturnCode", returnCode);
    results.callStringMethod("getReturnMessage", message);

    %***********************************;
    %* Process the results             *;
    %***********************************;
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    if (returnCode eq 0) then
    do;
      logMsgPrimary=logMsgPrefix;
      if ("&lsaf_version" eq " ") then
      do;
        logMsg=" Latest version of &lsaf_path. was downloaded successfully to &local_path..";
      end;
      else
      do;
        logMsg=" Version &lsaf_version. of &lsaf_path. was downloaded successfully to &local_path..";
      end;
    end;
    else
    do;
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
      logMsg=" The file was not downloaded: &lsaf_path.." ;
    end;

    %***********************************;
    %* Print messages in log           *;
    %***********************************;
    put;
    put logMsgPrimary " " logMsg;
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));
    put logMsgPrefix " _lsafMsg_= " message ;
    put logMsgPrefix " _lsafRC_= " returnCode ;
    put;

    %***********************************;
    %* Set the macro variables         *;
    %***********************************;
    call symputx("_lsafRC_", returnCode);
    call symputx("_lsafMsg_", message);

  run;

%mend lsaf_downloadfile;
