%* lsaf_downloadaszipfromworkspace                                                                *;
%*                                                                                                *;
%* Downloads a SAS Life Science Analytics Framework workspace file or folder along with its       *;
%* content to a local computer as a ZIP file.                                                     *;
%*                                                                                                *;
%* macrotype LSAF                                                                                 *;
%* since 2.6                                                                                      *;
%* exposure external                                                                              *;
%*                                                                                                *;
%* History                                                                                        *;
%* 2021-11-05  initial programming                                                                *;
%*                                                                                                *;

%macro lsaf_downloadaszipfromworkspace(
  lsaf_path=,
  local_path=,
  lsaf_overwrite=
  ) /des='Downloads a SAS Life Science Analytics Framework workspace item as a zip file.';

  %****************************************;
  %* Initialize macro variables           *;
  %****************************************;
  %lsaf_getProductName();

  %global _lsafMsg_
          _lsafRC_
  ;

  %let _lsafRC_ =%str(-999);
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);

  %**********************************************;
  %* Start the datastep to call the java code   *;
  %**********************************************;
  data _null_;
    attrib returnCode      length=8
           message         length=$200
           logMsgPrefix    length=$70
           logMsgPrimary   length=$70
           logMsg          length=$300
    ;

    %***********************************;
    %* Declare the java objects        *;
    %***********************************;
    declare javaobj srv("com/sas/lsaf/macro/content/workspace/BatchWorkspaceService") ;
    declare javaobj results("com/sas/lsaf/macro/common/result/Result");

    %***********************************;
    %* Attempt the operation           *;
    %***********************************;
    srv.callStaticVoidMethod("downloadAsZip", "%bquote(&lsaf_path)", "%bquote(&local_path)", "%bquote(&lsaf_overwrite)", results) ;

    %***********************************;
    %* Retrieve the results            *;
    %***********************************;
    results.callIntMethod("getReturnCode", returnCode);
    results.callStringMethod("getReturnMessage", message);

    %***********************************;
    %* Print messages in log           *;
    %* Process the results             *;
    %***********************************;
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    if (returnCode ne 0) then
    do;
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
      logMsg=" Could not attempt the operation to download the item as a zip file: &lsaf_path.." ;
    end;
    else
    do;
      logMsgPrimary=logMsgPrefix;
      logMsg=" Attempted to download the item as a zip file: &lsaf_path.." ;
    end;
    
    put;
    put logMsgPrimary " " logMsg;
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));
    put logMsgPrefix " _lsafMsg_= " message ;
    put logMsgPrefix " _lsafRC_= " returnCode ;
    put;
    
    %***********************************;
    %* Set the macro variables         *;
    %***********************************;
    call symputx("_lsafRC_", returnCode);
    call symputx("_lsafMsg_", message);

  run;

%mend lsaf_downloadaszipfromworkspace;
