%* lsaf_disableversioning                                                                      *;
%*                                                                                             *;
%* Disables versioning for a repository file.                                                  *;
%*                                                                                             *;
%* History                                                                                     *;
%* 2014-04-07  initial coding                                                                  *;
%* 2016-10-03  release as external                                                             *;
%* 2021-08-13  Remove header documentation                                                     *;
%*                                                                                             *;

%macro lsaf_disableversioning(
  lsaf_path=,
  lsaf_comment=
  ) /des='Disable versioning on a SAS Life Science Analytics Framework repository file.';

  %****************************************;
  %* Initialize macro variables           *;
  %****************************************;
  %lsaf_getProductName();

  %global _lsafMsg_
          _lsafRC_
  ;

  %let _lsafRC_=%str(-999);
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);

  %**********************************************;
  %* Start the datastep to call the java code   *;
  %**********************************************;
  data _null_;
    attrib returnCode      length=8;
    attrib message         length=$200;
    attrib logMsgPrefix    length=$70;
    attrib logMsg          length=$300;
    attrib logMsgPrimary   length=$70;

    %***********************************;
    %* Declare the java objects        *;
    %***********************************;
    declare javaobj srv("com/sas/lsaf/macro/content/repository/RepositoryService");
    declare javaobj results("com/sas/lsaf/macro/common/result/Result");

    %***********************************;
    %* Attempt the operation           *;
    %***********************************;
    srv.callStaticVoidMethod("disableVersioning", "%bquote(&lsaf_path)", "%bquote(&lsaf_comment)", results);

    %***********************************;
    %* Retrieve the results            *;
    %***********************************;
    results.callIntMethod("getReturnCode", returnCode);
    results.callStringMethod("getReturnMessage", message);

    %***********************************;
    %* Process the results             *;
    %***********************************;
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    if (returnCode ne 0) then
    do;
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
      logMsg=" Unable to turn versioning off for the file: &lsaf_path.." ;
    end;
    else
    do;
      logMsgPrimary=logMsgPrefix;
      logMsg=" Disabled file versioning: &lsaf_path..";
    end;

    %***********************************;
    %* Print messages in log           *;
    %***********************************;
    put;
    put logMsgPrimary " " logMsg;
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));
    put logMsgPrefix " _lsafMsg_= " message ;
    put logMsgPrefix " _lsafRC_= " returnCode ;
    put;

    %***********************************;
    %* Set the macro variables         *;
    %***********************************;
    call symputx("_lsafRC_", returnCode);
    call symputx("_lsafMsg_", message);

  run;

%mend lsaf_disableversioning;
