%* lsaf_defautoflowenabled                                                                             *;
%*                                                                                                     *;
%* Indicates if the process definition autoflow is enabled.                                            *;
%*                                                                                                     *;
%* macrotype LSAF                                                                                      *;
%* since 2.5                                                                                           *;
%* exposure external                                                                                   *;
%*                                                                                                     *;
%* History                                                                                             *;
%* 2021-05-26  initial coding                                                                          *;
%* 2021-07-13  updated for new service name                                                            *;
%* 2021-08-10  Remove header documentation                                                             *;
%*                                                                                                     *;

%macro lsaf_defautoflowenabled(
  lsaf_processdefid=,
  lsaf_autoflowtype=
  ) /des='Is the process definition mapping complete?';

  %****************************************;
  %* Initialize macro variables           *;
  %****************************************;
  %lsaf_getProductName();

  %global _lsafdefautoflowenabled_
          _lsafMsg_
          _lsafRC_
  ;

  %let _lsafRC_ =%str(-999);
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);

  %**********************************************;
  %* Start the datastep to call the java code   *;
  %**********************************************;
  data _null_;
    attrib returnCode        length=8;
    attrib message           length=$200;
    attrib logMsgPrefix      length=$70;
    attrib logMsgPrimary     length=$70;
    attrib logMsg            length=$300;
    attrib isEnabled         length=3;

    %***********************************;
    %* Declare the java objects        *;
    %***********************************;
    declare javaobj srv("com/sas/lsaf/macro/workflow/definition/mapping/ProcessDefinitionMappingService");
    declare javaobj results("com/sas/lsaf/macro/common/result/Result");
    
    %***********************************;
    %* Attempt the operation           *;
    %***********************************;
    srv.callStaticBooleanMethod("processDefinitionAutoflowEnabled", "%bquote(&lsaf_processdefid)", "%bquote(&lsaf_autoflowtype)", results, isEnabled);

    %***********************************;
    %* Retrieve the results            *;
    %***********************************;
    results.callIntMethod("getReturnCode", returnCode);
    results.callStringMethod("getReturnMessage", message);

    %***********************************;
    %* Process the results             *;
    %***********************************;
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    if (returnCode ne 0) then
    do;
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
      logMsg=" Cannot determine if the process definition autoflow is enabled." ;
      isEnabled=-1;
    end;
    else
    do;
      logMsgPrimary=logMsgPrefix;
      if (isEnabled) then
      do;
        logMsg=" The process definition autoflow is enabled.";
      end;
      else
      do;
        logMsg=" The process definition autoflow is NOT enabled.";
      end;
    end;

    %***********************************;
    %* Print messages in log           *;
    %***********************************;
    put;
    put logMsgPrimary " " logMsg;
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));
    put logMsgPrefix " _lsafMsg_= " message;
    put logMsgPrefix " _lsafRC_= " returnCode;
    put logMsgPrefix " _lsafdefautoflowenabled_= " isEnabled ;
    put;

    %***********************************;
    %* Set the macro variables         *;
    %***********************************;
    call symputx("_lsafRC_", returnCode);
    call symputx("_lsafMsg_", message);
    call symputx("_lsafdefautoflowenabled_", isEnabled);

  run;

%mend lsaf_defautoflowenabled;
