%* lsaf_createuser                                                                                 *;
%*                                                                                                 *;
%* Creates a user account.                                                                         *;
%*                                                                                                 *;
%* macrotype LSAF                                                                                  *;
%* since 1.3                                                                                       *;
%* exposure external                                                                               *;
%*                                                                                                 *;
%* History                                                                                         *;
%* 2013-10-30  initial coding                                                                      *;
%* 2016-08-26  rebrand as LSAF                                                                     *;
%* 2020-12-04  updates for service refactor                                                        *;
%* 2021-08-18  Remove header documentation                                                         *;
%*                                                                                                 *;

%macro lsaf_createuser(
  lsaf_userid=,
  lsaf_displayname=,
  lsaf_email=,
  lsaf_accounttype=,
  lsaf_password=,
  lsaf_firstname=,
  lsaf_lastname=,
  lsaf_department=,
  lsaf_phone=
  ) /des='Create a user account in the system.';

  %****************************************;
  %* Initialize macro variables           *;
  %****************************************;
  %lsaf_getProductName();

  %global _lsafMsg_
          _lsafRC_
  ;

  %let _lsafRC_=%str(-999);
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);

  %**********************************************;
  %* Start the datastep to call the java code   *;
  %**********************************************;
  data _null_;
    attrib returnCode      length=8;
    attrib message         length=$200;
    attrib logMsgPrefix    length=$70;
    attrib logMsgPrimary   length=$70;
    attrib logMsg          length=$300;

    %***********************************;
    %* Declare the java objects        *;
    %***********************************;
    declare javaobj srv("com/sas/lsaf/macro/security/user/UserService");
    declare javaobj results("com/sas/lsaf/macro/common/result/Result");

    %***********************************;
    %* Attempt the operation           *;
    %***********************************;
    srv.callStaticVoidMethod("create", "%bquote(&lsaf_userid)", "%bquote(&lsaf_displayname)", "%bquote(&lsaf_email)",
                             "%bquote(&lsaf_accounttype)", "%bquote(&lsaf_password)", "%bquote(&lsaf_firstname)",
                             "%bquote(&lsaf_lastname)", "%bquote(&lsaf_department)", "%bquote(&lsaf_phone)", results);

    %***********************************;
    %* Retrieve the results            *;
    %***********************************;
    results.callIntMethod("getReturnCode", returnCode);
    results.callStringMethod("getReturnMessage", message);

    %***********************************;
    %* Process the results             *;
    %***********************************;
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    logMsgPrimary=logMsgPrefix;
    logMsg=" The user &lsaf_userid was created." ;
    if (returnCode ne 0) then
    do;
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
      logMsg=" Cannot create user &lsaf_userid." ;
    end;

    %***********************************;
    %* Print messages in log           *;
    %***********************************;
    put;
    put logMsgPrimary " " logMsg;
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));
    put logMsgPrefix " _lsafMsg_= " message ;
    put logMsgPrefix " _lsafRC_= " returnCode ;
    put;

    %***********************************;
    %* Set the macro variables         *;
    %***********************************;
    call symputx("_lsafRC_", returnCode);
    call symputx("_lsafMsg_", message);

  run;

%mend lsaf_createuser;
