%* lsaf_createprocessflowmanifest                                                                 *;
%*                                                                                                *;
%* Creates a process flow manifest file in the repository. The SAS macro                          *;
%* variable _lsafCreatedProcessFlowManifest_ is set to the full path of the process flow          *;
%* manifest file, which includes the file extension. If the process flow manifest cannot be       *;
%* created, _lsafCreatedProcessFlowManifest_ is set to blank.                                     *;
%*                                                                                                *;
%* macrotype LSAF                                                                                 *;
%* since 1.5                                                                                      *;
%* exposure external                                                                              *;
%*                                                                                                *;
%* History                                                                                        *;
%* 2016-11-15  initial programming                                                                *;
%* 2019-02-12  update to 2.1                                                                      *;
%* 2019-08-28  update file path length to $2048                                                   *;
%* 2020-11-30  update for versioning strategy.                                                    *;
%* 2021-08-12  Remove header documentation                                                        *;
%* 2021-12-06  2.6 US11794 - add overwrite flag                                                   *;
%*                                                                                                *;

%macro lsaf_createprocessflowmanifest(
  lsaf_path=,
  lsaf_processflow=,
  lsaf_manifest_path=,
  lsaf_overwrite=,
  lsaf_enableversioning=,
  lsaf_versiontype=,
  lsaf_customversion=,
  lsaf_comment=
  ) /des='Create a manifest file for the specifed process flow in the indicated SAS Life Science Analytics Framework location.';

  %****************************************;
  %* Initialize macro variables           *;
  %****************************************;
  %lsaf_getProductName();

  %global _lsafCreatedProcessFlowManifest_
          _lsafMsg_
          _lsafRC_
  ;

  %let _lsafRC_=%str(-999);
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);

  %**********************************************;
  %* Start the datastep to call the java code   *;
  %**********************************************;
  data _null_;
    attrib returnCode     length=8
           message        length=$200
           logMsgPrefix   length=$70
           logMsgPrimary  length=$70
           logMsg         length=$300
           manifestPath   length=$2048
    ;
    manifestPath="";

    %***********************************;
    %* Declare the java objects        *;
    %***********************************;
    declare javaobj srv("com/sas/lsaf/macro/workflow/processflow/ProcessFlowService");
    declare javaobj fileParameters("com/sas/lsaf/macro/content/SasFileCreateParameters", "%bquote(&lsaf_manifest_path)", "%bquote(&lsaf_overwrite)", 
                              "%bquote(&lsaf_enableversioning)", "%bquote(&lsaf_versiontype)", "%bquote(&lsaf_customversion)", "%bquote(&lsaf_comment)"); 
    declare javaobj results("com/sas/lsaf/macro/common/result/Result");


    %***********************************;
    %* Attempt the operation           *;
    %***********************************;
    srv.callStaticStringMethod("createManifest", "%bquote(&lsaf_path)", "%bquote(&lsaf_processflow)", fileParameters, results, manifestPath);

    %***********************************;
    %* Retrieve the results            *;
    %***********************************;
    results.callIntMethod("getReturnCode", returnCode);
    results.callStringMethod("getReturnMessage", message);

    %***********************************;
    %* Process the results             *;
    %***********************************;
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    if (returnCode ne 0) then
    do;
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
      logMsg=" Cannot create a manifest for process flow &lsaf_processflow in &lsaf_manifest_path.." ;
    end;
    else
    do;
      logMsgPrimary=logMsgPrefix;
      logMsg=" The manifest " || strip(manifestPath) || " was created." ;
    end;

    %***********************************;
    %* Print messages in log           *;
    %***********************************;
    put;
    put logMsgPrimary " " logMsg;
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));
    put logMsgPrefix " _lsafMsg_= " message ;
    put logMsgPrefix " _lsafRC_= " returnCode ;
    put logMsgPrefix " _lsafCreatedProcessFlowManifest_= " manifestPath;
    put;

    %***********************************;
    %* Set the macro variables         *;
    %***********************************;
    call symputx("_lsafRC_", returnCode);
    call symputx("_lsafMsg_", message);
    call symputx("_lsafCreatedProcessFlowManifest_", manifestPath);

  run;

%mend lsaf_createprocessflowmanifest;
