%* lsaf_createprocessflow                                                                        *;
%*                                                                                               *;
%* Creates a process flow in the specified context.                                              *;
%*                                                                                               *;
%* macrotype LSAF                                                                                *;
%* since 1.5                                                                                     *;
%* exposure external                                                                             *;
%*                                                                                               *;
%* History                                                                                       *;
%* 2016-08-30  initial programming                                                               *;
%* 2019-02-12  update to 2.1                                                                     *;
%* 2021-08-12  Remove header documentation                                                       *;
%* 2021-12-06  2.6 US11676: Changed parameter to lsaf_processdefid                               *;
%* 2022-01-07  2.6 US11677: return id of new process flow                                        *;
%*                                                                                               *;

%macro lsaf_createprocessflow(
  lsaf_path=,
  lsaf_processflow=,
  lsaf_processdefid=
  ) /des='Create a process flow in the specified SAS Life Science Analytics Framework context.';

  %****************************************;
  %* Initialize macro variables           *;
  %****************************************;
  %lsaf_getProductName();

  %global _lsafMsg_
          _lsafProcessFlowId_
          _lsafRC_
  ;

  %let _lsafRC_=%str(-999);
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);

  %**********************************************;
  %* Start the datastep to call the java code   *;
  %**********************************************;
  data _null_;
    attrib returnCode      length=8
           message         length=$200
           logMsgPrefix    length=$70
           logMsgPrimary   length=$70
           logMsg          length=$300
           processFlowId   length=$64
	;

    %***********************************;
    %* Declare the java objects        *;
    %***********************************;
    declare javaobj srv("com/sas/lsaf/macro/workflow/processflow/ProcessFlowService");
    declare javaobj results("com/sas/lsaf/macro/common/result/Result");

    %***********************************;
    %* Attempt the operation           *;
    %***********************************;
    srv.callStaticStringMethod("create", "%bquote(&lsaf_path)", "%bquote(&lsaf_processflow)", "%bquote(&lsaf_processdefid)", results, processFlowId);

    %***********************************;
    %* Retrieve the results            *;
    %***********************************;
    results.callIntMethod("getReturnCode", returnCode);
    results.callStringMethod("getReturnMessage", message);

    %***********************************;
    %* Process the results             *;
    %***********************************;
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    if (returnCode ne 0) then
    do;
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
      logMsg=" Cannot create process flow &lsaf_processflow in &lsaf_path.." ;
    end;
    else
    do;
      logMsgPrimary=logMsgPrefix;
      logMsg=" The process flow &lsaf_processflow was created in &lsaf_path.." ;
    end;

    %***********************************;
    %* Print messages in log           *;
    %***********************************;
    put;
    put logMsgPrimary " " logMsg;
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));
    put logMsgPrefix " _lsafMsg_= " message ;
    put logMsgPrefix " _lsafRC_= " returnCode ;
    put logMsgPrefix " _lsafProcessFlowId_= " processFlowId;
    put;

    %***********************************;
    %* Set the macro variables         *;
    %***********************************;
    call symputx("_lsafRC_", returnCode);
    call symputx("_lsafMsg_", message);
    call symputx("_lsafProcessFlowId_", processFlowId) ;
  run;

%mend lsaf_createprocessflow;
