%* lsaf_creategroup                                                                          *;
%*                                                                                           *;
%* Creates a group in the specified context.                                                 *;
%*                                                                                           *;
%* macrotype LSAF                                                                            *;
%* since 1.2                                                                                 *;
%* exposure external                                                                         *;
%*                                                                                           *;
%* History                                                                                   *;
%* 2013-08-30  updates for standardization and coding conventions                            *;
%* 2016-08-26  rebrand as LSAF                                                               *;
%* 2019-01-21  updates for LSAF 5.1 behavior.                                                *;
%* 2020-12-04  updates for service refactor                                                  *;
%* 2021-08-06  Remove header documentation                                                   *;
%*                                                                                           *;

%macro lsaf_creategroup(
  lsaf_path=,
  lsaf_group=,
  lsaf_description=
  ) /des='Create a group in the specified context.';

  %****************************************;
  %* Initialize macro variables           *;
  %****************************************;
  %lsaf_getProductName();

  %global _lsafMsg_
          _lsafRC_
  ;

  %let _lsafRC_=%str(-999);
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);

  %**********************************************;
  %* Start the datastep to call the java code   *;
  %**********************************************;
  data _null_;
    attrib returnCode      length=8;
    attrib message         length=$200;
    attrib logMsgPrefix    length=$70;
    attrib logMsgPrimary   length=$70;
    attrib logMsg          length=$300;

    %***********************************;
    %* Declare the java objects        *;
    %***********************************;
    declare javaobj srv("com/sas/lsaf/macro/security/group/GroupService");
    declare javaobj results("com/sas/lsaf/macro/common/result/Result");

    %***********************************;
    %* Attempt the operation           *;
    %***********************************;
    srv.callStaticVoidMethod("create", "%bquote(&lsaf_path)", "%bquote(&lsaf_group)", "%bquote(&lsaf_description)", results);

    %***********************************;
    %* Retrieve the results            *;
    %***********************************;
    results.callIntMethod("getReturnCode", returnCode);
    results.callStringMethod("getReturnMessage", message);

    %***********************************;
    %* Process the results             *;
    %***********************************;
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    logMsgPrimary=logMsgPrefix;
    logMsg=" The group &lsaf_group was created in &lsaf_path.." ;
    if (returnCode ne 0) then
    do;
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
      logMsg=" Cannot create group &lsaf_group in &lsaf_path.." ;
    end;

    %***********************************;
    %* Print messages in log           *;
    %***********************************;
    put;
    put logMsgPrimary " " logMsg;
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));
    put logMsgPrefix " _lsafMsg_= " message ;
    put logMsgPrefix " _lsafRC_= " returnCode ;
    put;

    %***********************************;
    %* Set the macro variables         *;
    %***********************************;
    call symputx("_lsafRC_", returnCode);
    call symputx("_lsafMsg_", message);

  run;

%mend lsaf_creategroup ;
