%* lsaf_createglobaltlftemplate                                                                    *;
%*                                                                                                 *;
%* Creates a new global TLF template.                                                              *;
%*                                                                                                 *;
%* macrotype LSAF                                                                                  *;
%* since 2.5                                                                                       *;
%* exposure external                                                                               *;
%*                                                                                                 *;
%* History                                                                                         *;
%* 2021-06-09  initial coding                                                                      *;
%* 2021-08-17  Remove header documentation                                                         *;
%*                                                                                                 *;

%macro lsaf_createglobaltlftemplate(
  lsaf_name=,
  lsaf_description=
  ) /des='Creates a new global TLF template.';

  %****************************************;
  %* Initialize macro variables           *;
  %****************************************;
  %lsaf_getProductName();

  %global _lsafMsg_
          _lsafRC_
          _lsaftlftemplateid_
  ;

  %let _lsafRC_=%str(-999);
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);

  %**********************************************;
  %* Start the datastep to call the java code   *;
  %**********************************************;
  data _null_;
    attrib returnCode      length=8;
    attrib message         length=$200;
    attrib logMsgPrefix    length=$70;
    attrib logMsg          length=$300;
    attrib logMsgPrimary   length=$70;
    attrib tlfId           length=$100;

    %***********************************;
    %* Declare the java objects        *;
    %***********************************;
    declare javaobj srv("com/sas/lsaf/macro/clinical/tlf/TlfTemplateService");
    declare javaobj results("com/sas/lsaf/macro/common/result/Result");

    %***********************************;
    %* Attempt the operation           *;
    %***********************************;
    srv.callStaticStringMethod("createTlfTemplate", "%bquote(&lsaf_name)", "%bquote(&lsaf_description)", results, tlfId);

    %***********************************;
    %* Retrieve the results            *;
    %***********************************;
    results.callIntMethod("getReturnCode", returnCode);
    results.callStringMethod("getReturnMessage", message);

    %***********************************;
    %* Process the results             *;
    %***********************************;
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    if (returnCode eq 0) then
    do;
      logMsgPrimary=logMsgPrefix;
      logMsg=" Global TLF Template was created";
    end;
    else
    do;
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
      logMsg=" Global TLF Template was not created" ;
    end;

    %***********************************;
    %* Print messages in log           *;
    %***********************************;
    put;
    put logMsgPrimary " " logMsg;
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));
    put logMsgPrefix " _lsafMsg_= " message ;
    put logMsgPrefix " _lsafRC_= " returnCode ;
    put logMsgPrefix " _lsaftlftemplateid_= " tlfId ;
    put;

    %***********************************;
    %* Set the macro variables         *;
    %***********************************;
    call symputx("_lsafRC_", returnCode);
    call symputx("_lsafMsg_", message);
    call symputx("_lsaftlftemplateid_", tlfId);

  run;

%mend lsaf_createglobaltlftemplate ;
