%* lsaf_createfolder                                                                       *;
%*                                                                                         *;
%* Creates a folder in the repository.                                                     *;
%*                                                                                         *;
%* macrotype LSAF                                                                          *;
%* since 1.1                                                                               *;
%* exposure external                                                                       *;
%*                                                                                         *;
%* History                                                                                 *;
%* 2013-08-30  updates for standardization and coding conventions                          *;
%* 2016-08-26  rebrand as LSAF                                                             *;
%* 2018-12-10  documentation update for LSAF 5.x behavior                                  *;
%* 2021-08-13  Remove header documentation                                                 *;
%*                                                                                         *;

%macro lsaf_createfolder(
  lsaf_path=
  ) /des='Create a folder.';

  %****************************************;
  %* Initialize macro variables           *;
  %****************************************;
  %lsaf_getProductName();

  %global _lsafMsg_
          _lsafRC_
  ;

  %let _lsafRC_=%str(-999);
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);

  %**********************************************;
  %* Start the datastep to call the java code   *;
  %**********************************************;
  data _null_;
    attrib returnCode      length=8;
    attrib message         length=$200;
    attrib logMsgPrefix    length=$70;
    attrib logMsg          length=$300;
    attrib logMsgPrimary   length=$70;

    %***********************************;
    %* Declare the java objects        *;
    %***********************************;
    declare javaobj cmd("com/sas/lsaf/macro/content/repository/RepositoryService");
    declare javaobj results("com/sas/lsaf/macro/common/result/Result");

    %***********************************;
    %* Attempt the operation           *;
    %***********************************;
    cmd.callStaticVoidMethod("createFolder", "%bquote(&lsaf_path)", results);

    %***********************************;
    %* Retrieve the results            *;
    %***********************************;
    results.callIntMethod("getReturnCode", returnCode);
    results.callStringMethod("getReturnMessage", message);

    %***********************************;
    %* Process the results             *;
    %***********************************;
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    logMsgPrimary=logMsgPrefix;
    logMsg=" The folder was created: &lsaf_path" ;
    if (returnCode ne 0) then
    do;
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
      logMsg=" The folder was not created: &lsaf_path" ;
    end;

    %***********************************;
    %* Print messages in log           *;
    %***********************************;
    put;
    put logMsgPrimary " " logMsg;
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));
    put logMsgPrefix " _lsafMsg_= " message ;
    put logMsgPrefix " _lsafRC_= " returnCode ;
    put;

    %***********************************;
    %* Set the macro variables         *;
    %***********************************;
    call symputx("_lsafRC_", returnCode);
    call symputx("_lsafMsg_", message);

  run;

%mend lsaf_createfolder ;
