%* lsaf_createfile                                                                                 *;
%*                                                                                                 *;
%* Uploads a file from the local machine to the repository.                                        *;
%*                                                                                                 *;
%* macrotype LSAF                                                                                  *;
%* since 1.1                                                                                       *;
%* exposure external                                                                               *;
%*                                                                                                 *;
%* History                                                                                         *;
%* 2013-08-30  updates for standardization and coding conventions                                  *;
%* 2016-08-29  rebrand as LSAF                                                                     *;
%* 2018-12-10  documentation update for LSAF 5.x behavior                                          *;
%* 2021-08-13  Remove header documentation                                                         *;
%*                                                                                                 *;

%macro lsaf_createfile(
  local_path=,
  lsaf_path=,
  lsaf_enableversioning=,
  lsaf_version=,
  lsaf_comment=
  ) /des='Upload a file from the local computer as a new file into SAS Life Science Analytics Framework.';

  %****************************************;
  %* Initialize macro variables           *;
  %****************************************;
  %lsaf_getProductName();

  %global _lsafMsg_
          _lsafRC_
  ;

  %let _lsafRC_=%str(-999);
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);

  %**********************************************;
  %* Start the datastep to call the java code   *;
  %**********************************************;
  data _null_;
    attrib returnCode      length=8;
    attrib message         length=$200;
    attrib logMsgPrefix    length=$70;
    attrib logMsg          length=$300;
    attrib logMsgPrimary   length=$70;

    %***********************************;
    %* Declare the java objects        *;
    %***********************************;
    declare javaobj srv("com/sas/lsaf/macro/content/repository/RepositoryService");
    declare javaobj results("com/sas/lsaf/macro/common/result/Result");

    %***********************************;
    %* Attempt the operation           *;
    %***********************************;
    srv.callStaticVoidMethod("createFile", "%bquote(&local_path)", "%bquote(&lsaf_path)", "%bquote(&lsaf_enableversioning)", "%bquote(&lsaf_version)", "%bquote(&lsaf_comment)", results);

    %***********************************;
    %* Retrieve the results            *;
    %***********************************;
    results.callIntMethod("getReturnCode", returnCode);
    results.callStringMethod("getReturnMessage", message);

    %***********************************;
    %* Process the results             *;
    %***********************************;
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    if (returnCode eq 0) then
    do;
      logMsgPrimary=logMsgPrefix;
      if ("&lsaf_enableversioning" eq "1") then
      do;
        logMsg=" Versioned file created as version &lsaf_version at &lsaf_path";
      end;
      else
      do;
        logMsg=" Unversioned file was created at &lsaf_path";
      end;
    end;
    else
    do;
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
      logMsg=" The file was not created: &lsaf_path" ;
    end;

    %***********************************;
    %* Print messages in log           *;
    %***********************************;
    put;
    put logMsgPrimary " " logMsg;
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));
    put logMsgPrefix " _lsafMsg_= " message ;
    put logMsgPrefix " _lsafRC_= " returnCode ;
    put logMsgPrefix " local_path= &local_path" ;
    put;

    %***********************************;
    %* Set the macro variables         *;
    %***********************************;
    call symputx("_lsafRC_", returnCode);
    call symputx("_lsafMsg_", message);

  run;

%mend lsaf_createfile ;
