%* lsaf_createemptystudytables                                                                        *;
%*                                                                                                    *;
%* Creates a zero-observation data set in the repository for each table in a study.                   *;
%*                                                                                                    *;
%* macrotype LSAF                                                                                     *;
%* since 2.2                                                                                          *;
%* exposure external                                                                                  *;
%*                                                                                                    *;
%* History                                                                                            *;
%* 2019-08-16  initial coding                                                                         *;
%* 2021-08-16  Remove header documentation                                                            *;
%*                                                                                                    *;

%macro lsaf_createemptystudytables(
  lsaf_studyid=,
  lsaf_basestandardname=,
  lsaf_modelid=,
  lsaf_path=,
  lsaf_overwrite=,
  lsaf_enableversioning=,
  lsaf_versiontypefornewfiles=,
  lsaf_customversfornewfiles=,
  lsaf_versiontypeforexistingfiles=,
  lsaf_customversforexistingfiles=,
  lsaf_comment=
  ) /des='Creates a zero observation data set in the repository for each table in the study.';

  %****************************************;
  %* Initialize macro variables           *;
  %****************************************;
  %lsaf_getProductName();

  %global _lsafMsg_
          _lsafRC_
  ;


  %let _lsafRC_ =%str(-999);
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);

  %**********************************************;
  %* Start the datastep to call the java code   *;
  %**********************************************;
  data _null_;
    attrib returnCode         length=8
           message            length=$200
           logMsgPrefix       length=$70
           logMsgPrimary      length=$70
           logMsg             length=$300
           returnpath         length=$2048    label="Return value from method. NOT REPORTED TO USER."
    ;

    %*****************************;
    %* Declare the java objects  *;
    %*****************************;
    declare javaobj srv("com/sas/lsaf/macro/clinical/study/StudyService") ;
    declare javaobj exportData("com/sas/lsaf/macro/content/SasBatchFileCreateParameters");
    declare javaobj results("com/sas/lsaf/macro/common/result/Result");
 
    %***********************************;
    %* Attempt the operation           *;
    %***********************************;
    
    exportData.callVoidMethod("updateBatchData", "%bquote(&lsaf_path)", "%bquote(&lsaf_overwrite)", "%bquote(&lsaf_enableversioning)", 
          "%bquote(&lsaf_versiontypefornewfiles)", "%bquote(&lsaf_customversfornewfiles)", "%bquote(&lsaf_comment)", 
          "%bquote(&lsaf_versiontypeforexistingfiles)", "%bquote(&lsaf_customversforexistingfiles)", "%bquote()");
    
    srv.callStaticStringMethod("exportTableZeroObsDatasetsToRepository", "%bquote(&lsaf_studyid)", "%bquote(&lsaf_basestandardname)", "%bquote(&lsaf_modelid)", 
      exportData, results, returnpath);

    %***********************************;
    %* Retrieve the results            *;
    %***********************************;
    results.callIntMethod("getReturnCode", returnCode);
    results.callStringMethod("getReturnMessage", message);
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    if (returnCode ne 0) then
    do;
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
      logMsg=" Could not create empty data sets for the study." ;
    end;
    else
    do;
      logMsgPrimary=logMsgPrefix;
      logMsg=" Empty data sets were created for the study.";
    end;

    %***********************************;
    %* Print messages in log           *;
    %***********************************;
    put;
    put logMsgPrimary " " logMsg;
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));
    put logMsgPrefix " _lsafMsg_= " message ;
    put logMsgPrefix " _lsafRC_= " returnCode ;
    put;

    %***********************************;
    %* Set the macro variables         *;
    %***********************************;
    call symputx("_lsafRC_", returnCode);
    call symputx("_lsafMsg_", message);
  run;

%mend lsaf_createemptystudytables;
