%* lsaf_createcontext                                                                      *;
%*                                                                                         *;
%* Creates a context in the repository.                                                    *;
%*                                                                                         *;
%* macrotype LSAF                                                                          *;
%* since 2.1                                                                               *;
%* exposure external                                                                       *;
%*                                                                                         *;
%* 2021-08-13  Remove header documentation                                                 *;
%*                                                                                         *;
                                                                                                                                                                                                                                                                                                                                     
%macro lsaf_createcontext(                                                                                                                                                                                                                                                                                                           
  lsaf_path=,
  lsaf_typeid=
  ) /des='Create a context in the SAS Life Science Analytics Framework repository.';                                                                                                                                                                                                                                                 
                                                                                                                                                                                                                                                                                                                                     
  %****************************************;                                                                                                                                                                                                                                                                                         
  %* Initialize macro variables           *;                                                                                                                                                                                                                                                                                         
  %****************************************;                                                                                                                                                                                                                                                                                         
  %lsaf_getProductName();                                                                                                                                                                                                                                                                                                            
                                                                                                                                                                                                                                                                                                                                     
  %global _lsafMsg_                                                                                                                                                                                                                                                                                                                  
          _lsafRC_                                                                                                                                                                                                                                                                                                                   
  ;                                                                                                                                                                                                                                                                                                                                  
                                                                                                                                                                                                                                                                                                                                     
  %let _lsafRC_=%str(-999);                                                                                                                                                                                                                                                                                                          
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);                                                                                                                                                                                                                                                
                                                                                                                                                                                                                                                                                                                                     
  %**********************************************;                                                                                                                                                                                                                                                                                   
  %* Start the datastep to call the java code   *;                                                                                                                                                                                                                                                                                   
  %**********************************************;                                                                                                                                                                                                                                                                                   
  data _null_;                                                                                                                                                                                                                                                                                                                       
    attrib returnCode      length=8;                                                                                                                                                                                                                                                                                                 
    attrib message         length=$200;                                                                                                                                                                                                                                                                                              
    attrib logMsgPrefix    length=$70;                                                                                                                                                                                                                                                                                               
    attrib logMsg          length=$300;                                                                                                                                                                                                                                                                                              
    attrib logMsgPrimary   length=$70;                                                                                                                                                                                                                                                                                               
                                                                                                                                                                                                                                                                                                                                     
    %***********************************;                                                                                                                                                                                                                                                                                            
    %* Declare the java objects        *;                                                                                                                                                                                                                                                                                            
    %***********************************;                                                                                                                                                                                                                                                                                            
    declare javaobj srv("com/sas/lsaf/macro/content/repository/RepositoryService");                                                                                                                                                                                                                                                                 
    declare javaobj results("com/sas/lsaf/macro/common/result/Result");
                                                                                                                                                                                                                                                                                                                                     
    %***********************************;                                                                                                                                                                                                                                                                                            
    %* Attempt the operation           *;                                                                                                                                                                                                                                                                                            
    %***********************************;                                                                                                                                                                                                                                                                                            
    srv.callStaticVoidMethod("createContext", "%bquote(&lsaf_path)", "%bquote(&lsaf_typeid)", results);                                                                                                                                                                                                                                                              
                                                                                                                                                                                                                                                                                                                                     
    %***********************************;                                                                                                                                                                                                                                                                                            
    %* Retrieve the results            *;                                                                                                                                                                                                                                                                                            
    %***********************************;                                                                                                                                                                                                                                                                                            
    results.callIntMethod("getReturnCode", returnCode);                                                                                                                                                                                                                                                                              
    results.callStringMethod("getReturnMessage", message);                                                                                                                                                                                                                                                                           
                                                                                                                                                                                                                                                                                                                                     
    %***********************************;                                                                                                                                                                                                                                                                                            
    %* Process the results             *;                                                                                                                                                                                                                                                                                            
    %***********************************;                                                                                                                                                                                                                                                                                            
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";                                                                                                                                                                                                                                                                             
    logMsgPrimary=logMsgPrefix;
    logMsg=" The context was created: &lsaf_path as type: &lsaf_typeid" ;                                                                                                                                                                                                                                                                                
    if (returnCode ne 0) then                                                                                                                                                                                                                                                                                                        
    do;                                                                                                                                                                                                                                                                                                                              
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";                                                                                                                                                                                                                                                                       
      logMsg=" Cannot create context: &lsaf_path" ;                                                                                                                                                                                                                                                                                  
    end;                                                                                                                                                                                                                                                                                                                             
                                                                                                                                                                                                                                                                                                                                     
    %***********************************;                                                                                                                                                                                                                                                                                            
    %* Print messages in log           *;                                                                                                                                                                                                                                                                                            
    %***********************************;                                                                                                                                                                                                                                                                                            
    put;                                                                                                                                                                                                                                                                                                                             
    put logMsgPrimary " " logMsg;                                                                                                                                                                                                                                                                                                     
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));                                                                                                                                                                                                                                                                         
    put logMsgPrefix " _lsafMsg_= " message ;                                                                                                                                                                                                                                                                                        
    put logMsgPrefix " _lsafRC_= " returnCode ;                                                                                                                                                                                                                                                                                      
    put;                                                                                                                                                                                                                                                                                                                             
                                                                                                                                                                                                                                                                                                                                     
    %***********************************;                                                                                                                                                                                                                                                                                            
    %* Set the macro variables         *;                                                                                                                                                                                                                                                                                            
    %***********************************;                                                                                                                                                                                                                                                                                            
    call symputx("_lsafRC_", returnCode);                                                                                                                                                                                                                                                                                            
    call symputx("_lsafMsg_", message);                                                                                                                                                                                                                                                                                              
                                                                                                                                                                                                                                                                                                                                     
  run;                                                                                                                                                                                                                                                                                                                               
                                                                                                                                                                                                                                                                                                                                     
%mend lsaf_createcontext;
