%* lsaf_createautoflow                                                      *;
%*                                                                          *;
%* Creates a process autoflow.                                              *;
%*                                                                          *;
%* macrotype LSAF                                                           *;
%* since 2.5                                                                *;
%* exposure external                                                        *;
%*                                                                          *;
%* History                                                                  *;
%* 2021-05-26  initial programming                                          *;
%*                                                                          *;

%macro lsaf_createautoflow(
  lsaf_contextid=,
  lsaf_processdefid=,
  lsaf_autoflowtype=,
  lsaf_nameprefix=,
  lsaf_sourceid=
  ) /des='Creates a process autoflow in the SAS Life Science Analytics Framework.';

  %****************************************;
  %* Initialize macro variables           *;
  %****************************************;
  %lsaf_getProductName();

  %global _lsafcreateautoflow_
          _lsafMsg_
          _lsafRC_
  ;

  %let _lsafRC_=%str(-999);
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);

  %**********************************************;
  %* Start the datastep to call the java code   *;
  %**********************************************;
  data _null_;
    attrib returnCode      length=8;
    attrib message         length=$200;
    attrib logMsgPrefix    length=$70;
    attrib logMsgPrimary   length=$70;
    attrib logMsg          length=$300;
    attrib autoflowid      length=$64;
    
    autoflowid='';

    %***********************************;
    %* Declare the java objects        *;
    %***********************************;
    declare javaobj srv("com/sas/lsaf/macro/workflow/autoflow/AutoflowService");
    declare javaobj results("com/sas/lsaf/macro/common/result/Result");

    %***********************************;
    %* Attempt the operation           *;
    %***********************************;
    srv.callStaticStringMethod("createAutoFlowProcess", "%bquote(&lsaf_contextid)", "%bquote(&lsaf_processdefid)", "%bquote(&lsaf_autoflowtype)", 
                             "%bquote(&lsaf_nameprefix)", "%bquote(&lsaf_sourceid)", results, autoflowId);

    %***********************************;
    %* Retrieve the results            *;
    %***********************************;
    results.callIntMethod("getReturnCode", returnCode);
    results.callStringMethod("getReturnMessage", message);

    %***********************************;
    %* Process the results             *;
    %***********************************;
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    if (returnCode ne 0) then
    do;
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
      logMsg=" Cannot create process autoflow &lsaf_processdefid in &lsaf_contextid.." ;
    end;
    else
    do;
      logMsgPrimary=logMsgPrefix;
      logMsg=" The process flow &lsaf_processdefid was created in &lsaf_contextid.." ;
    end;

    %***********************************;
    %* Print messages in log           *;
    %***********************************;
    put;
    put logMsgPrimary " " logMsg;
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));
    put logMsgPrefix " _lsafMsg_= " message ;
    put logMsgPrefix " _lsafRC_= " returnCode ;
    put logMsgPrefix " _lsafcreateautoflow_= " autoflowid ;
    put;

    %***********************************;
    %* Set the macro variables         *;
    %***********************************;
    call symputx("_lsafRC_", returnCode);
    call symputx("_lsafMsg_", message);
    call symputx("_lsafcreateautoflow_", autoflowid);

  run;

%mend lsaf_createautoflow;
