%* lsaf_copyprocessflow                                                                                  *;
%*                                                                                                       *;
%* Copies a process flow. The new process flow is created in the same context as the source process      *;
%* flow.                                                                                                 *;
%*                                                                                                       *;
%* History                                                                                               *;
%* 2020-10-09  Initial coding                                                                            *;
%* 2021-08-12  Remove header documentation                                                               *;
%* 2021-09-20  Remove parameter defaults (DE16775)                                                       *;
%* 2022-01-07  2.6 US11677: return id of new process flow                                                *;
%*                                                                                                       *;

%macro lsaf_copyprocessflow(
  lsaf_path=,
  lsaf_processflow=,
  lsaf_name=,
  lsaf_useSourceOwner=,
  lsaf_includeAttachments=,
  lsaf_includeProcessData=,
  lsaf_activateNewProcessFlow=
  ) /des='Copy the process flow.';

  %****************************************;
  %* Initialize macro variables           *;
  %****************************************;
  %lsaf_getProductName();

  %global _lsafCopiedFlowId_
          _lsafMsg_
          _lsafRC_
  ;

  %let _lsafRC_ =%str(-999);
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);

  %**********************************************;
  %* Start the datastep to call the java code   *;
  %**********************************************;
  data _null_;
    attrib returnCode      length=8
           message         length=$200
           logMsgPrefix    length=$70
           logMsgPrimary   length=$70
           logMsg          length=$300
           processFlowId   length=$64
    ;

    %***********************************;
    %* Declare the java objects        *;
    %***********************************;
    declare javaobj srv("com/sas/lsaf/macro/workflow/processflow/ProcessFlowService");
    declare javaobj results("com/sas/lsaf/macro/common/result/Result");

    %***********************************;
    %* Attempt the operation           *;
    %***********************************;
    srv.callStaticStringMethod("copyProcessFlow", "%bquote(&lsaf_path)", "%bquote(&lsaf_processflow)", "%bquote(&lsaf_name)", 
           "%bquote(&lsaf_useSourceOwner)", "%bquote(&lsaf_includeAttachments)", "%bquote(&lsaf_includeProcessData)", 
           "%bquote(&lsaf_activateNewProcessFlow)", results, processFlowId);

    %***********************************;
    %* Retrieve the results            *;
    %***********************************;
    results.callIntMethod("getReturnCode", returnCode);
    results.callStringMethod("getReturnMessage", message);

    %***********************************;
    %* Process the results             *;
    %***********************************;
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    if (returnCode ne 0) then
    do;
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
      logMsg=" Cannot copy process flow: &lsaf_processflow..";
    end;
    else
    do;
      logMsgPrimary=logMsgPrefix;
      logMsg=" The process flow: &lsaf_processflow was copied as &lsaf_name";
    end;

    %***********************************;
    %* Print messages in log           *;
    %***********************************;
    put;
    put logMsgPrimary " " logMsg;
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));
    put logMsgPrefix " _lsafMsg_= " message;
    put logMsgPrefix " _lsafRC_= " returnCode;
    put logMsgPrefix " _lsafCopiedProcessFlowId_= " processFlowId;
    put;

    %***********************************;
    %* Set the macro variables         *;
    %***********************************;
    call symputx("_lsafRC_", returnCode);
    call symputx("_lsafMsg_", message);
    call symputx("_lsafCopiedFlowId_", processFlowId) ;
  run;

%mend lsaf_copyprocessflow;
