%* lsaf_cleardefelementmappings                                                                  *;
%*                                                                                               *;
%* Clears the process definition element mappings                                                *;
%*                                                                                               *;
%* macrotype LSAF                                                                                *;
%* since 2.5                                                                                     *;
%* exposure external                                                                             *;
%*                                                                                               *;
%* History 2021-05-28  initial programming                                                       *;
%* 2021-05-28  initial programming                                                               *;
%* 2021-07-13  updated for new service name                                                      *;
%* 2021-08-10  Remove header documentation                                                       *;
%*                                                                                               *;


%macro lsaf_cleardefelementmappings(
  lsaf_processdefid=,
  lsaf_elementid=,
  lsaf_autoflowtype=
  ) /des='Clear process definition element mappings.';

  %****************************************;
  %* Initialize macro variables           *;
  %****************************************;
  %lsaf_getProductName();

  %global _lsafMsg_
          _lsafRC_
  ;

  %let _lsafRC_=%str(-999);
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);

  %**********************************************;
  %* Start the datastep to call the java code   *;
  %**********************************************;
  data _null_;
    attrib returnCode      length=8;
    attrib message         length=$200;
    attrib logMsgPrefix    length=$70;
    attrib logMsgPrimary   length=$70;
    attrib logMsg          length=$300;

    %***********************************;
    %* Declare the java objects        *;
    %***********************************;
    declare javaobj srv("com/sas/lsaf/macro/workflow/definition/mapping/ProcessDefinitionMappingService");
    declare javaobj results("com/sas/lsaf/macro/common/result/Result");

    %***********************************;
    %* Attempt the operation           *;
    %***********************************;
    srv.callStaticVoidMethod("clearProcessDefinitionElementMappings", "%bquote(&lsaf_processdefid)", "%bquote(&lsaf_elementid)",
                             "%bquote(&lsaf_autoflowtype)", results);

    %***********************************;
    %* Retrieve the results            *;
    %***********************************;
    results.callIntMethod("getReturnCode", returnCode);
    results.callStringMethod("getReturnMessage", message);

    %***********************************;
    %* Process the results             *;
    %***********************************;
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    if (returnCode ne 0) then
    do;
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
      logMsg=" Cannot clear process definition mappings for process &lsaf_processdefid. and element &lsaf_elementid.." ;
    end;
    else
    do;
      logMsgPrimary=logMsgPrefix;
      logMsg=" The process definition mappings for &lsaf_processdefid. and element &lsaf_elementid. were successfully cleared." ;
    end;

    %***********************************;
    %* Print messages in log           *;
    %***********************************;
    put;
    put logMsgPrimary " " logMsg;
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));
    put logMsgPrefix " _lsafMsg_= " message ;
    put logMsgPrefix " _lsafRC_= " returnCode ;
    put;

    %***********************************;
    %* Set the macro variables         *;
    %***********************************;
    call symputx("_lsafRC_", returnCode);
    call symputx("_lsafMsg_", message);

  run;

%mend lsaf_cleardefelementmappings;
