%* lsaf_assignpfusertask                                                                         *;
%*                                                                                               *;
%* Assigns a task to a specified user. If no user specified it will be umassigned.               *;
%*                                                                                               *;
%* macrotype LSAF                                                                                *;
%* since 2.5                                                                                     *;
%* exposure external                                                                             *;
%*                                                                                               *;
%* History                                                                                       *;
%* 2021-01-19  initial programming                                                               *;
%* 2021-08-12  Remove header documentation                                                       *;
%*                                                                                               *;

%macro lsaf_assignpfusertask(
  lsaf_taskId=,
  lsaf_userId=
  ) /des='Assign a process flow user task.';

  %****************************************;
  %* Initialize macro variables           *;
  %****************************************;
  %lsaf_getProductName();

  %global _lsafMsg_
          _lsafRC_
  ;

  %let _lsafRC_=%str(-999);
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);

  %**********************************************;
  %* Start the datastep to call the java code   *;
  %**********************************************;
  data _null_;
    attrib returnCode      length=8;
    attrib message         length=$200;
    attrib logMsgPrefix    length=$70;
    attrib logMsgPrimary   length=$70;
    attrib logMsg          length=$300;

    %***********************************;
    %* Declare the java objects        *;
    %***********************************;
    declare javaobj srv("com/sas/lsaf/macro/workflow/task/ProcessFlowTaskService");
    declare javaobj results("com/sas/lsaf/macro/common/result/Result");

    %***********************************;
    %* Attempt the operation           *;
    %***********************************;
    srv.callStaticVoidMethod("assignTask", "%bquote(&lsaf_taskId)", "%bquote(&lsaf_userId)", results);

    %***********************************;
    %* Retrieve the results            *;
    %***********************************;
    results.callIntMethod("getReturnCode", returnCode);
    results.callStringMethod("getReturnMessage", message);

    %***********************************;
    %* Process the results             *;
    %***********************************;
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    if (returnCode ne 0) then
    do;
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
      %if "&lsaf_userId" EQ "" %then
      %do;
        logMsg=" Cannot assign process flow task  &lsaf_taskId.." ;
      %end;
      %else
      %do;
        logMsg=" Cannot assign process flow task  &lsaf_taskId for user &lsaf_userId.." ;
      %end;
    end;
    else
    do;
      logMsgPrimary=logMsgPrefix;
      %if "&lsaf_userId" EQ "" %then
      %do;
        logMsg=" The process flow task &lsaf_taskId was set to unassigned." ;
      %end;
      %else
      %do;
        logMsg=" The process flow task &lsaf_taskId was assigned to user &lsaf_userId.." ;
      %end;
    end;

    %***********************************;
    %* Print messages in log           *;
    %***********************************;
    put;
    put logMsgPrimary " " logMsg;
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));
    put logMsgPrefix " _lsafMsg_= " message ;
    put logMsgPrefix " _lsafRC_= " returnCode ;
    put;

    %***********************************;
    %* Set the macro variables         *;
    %***********************************;
    call symputx("_lsafRC_", returnCode);
    call symputx("_lsafMsg_", message);

  run;

%mend lsaf_assignpfusertask;
