%* lsaf_activateprocessflow                                                                              *;
%*                                                                                                       *;
%* Activates a process flow.                                                                             *;
%*                                                                                                       *;
%* macrotype LSAF                                                                                        *;
%* since 2.2                                                                                             *;
%* exposure external                                                                                     *;
%*                                                                                                       *;
%* History                                                                                               *;
%* 2019-09-20  Initial coding                                                                            *;
%* 2021-08-12  Remove header documentation                                                               *;
%*                                                                                                       *;

%macro lsaf_activateprocessflow(
  lsaf_path=,
  lsaf_processflow=
  ) /des='Activate the process flow.';

  %****************************************;
  %* Initialize macro variables           *;
  %****************************************;
  %lsaf_getProductName();

  %global _lsafMsg_
          _lsafRC_
  ;

  %let _lsafRC_ =%str(-999);
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);

  %**********************************************;
  %* Start the datastep to call the java code   *;
  %**********************************************;
  data _null_;
    attrib returnCode      length=8
           message         length=$200
           logMsgPrefix    length=$70
           logMsgPrimary   length=$70
           logMsg          length=$300
           ;

    %***********************************;
    %* Declare the java objects        *;
    %***********************************;
    declare javaobj srv("com/sas/lsaf/macro/workflow/processflow/ProcessFlowService");
    declare javaobj results("com/sas/lsaf/macro/common/result/Result");

    %***********************************;
    %* Attempt the operation           *;
    %***********************************;
    srv.callStaticVoidMethod("activateProcessFlow", "%bquote(&lsaf_path)", "%bquote(&lsaf_processflow)", results);

    %***********************************;
    %* Retrieve the results            *;
    %***********************************;
    results.callIntMethod("getReturnCode", returnCode);
    results.callStringMethod("getReturnMessage", message);

    %***********************************;
    %* Process the results             *;
    %***********************************;
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    if (returnCode ne 0) then
    do;
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
      logMsg=" Cannot activate process flow: &lsaf_processflow..";
    end;
    else
    do;
      logMsgPrimary=logMsgPrefix;
      logMsg=" The process flow: &lsaf_processflow was activated.";
    end;

    %***********************************;
    %* Print messages in log           *;
    %***********************************;
    put;
    put logMsgPrimary " " logMsg;
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));
    put logMsgPrefix " _lsafMsg_= " message;
    put logMsgPrefix " _lsafRC_= " returnCode;
    put;

    %***********************************;
    %* Set the macro variables         *;
    %***********************************;
    call symputx("_lsafRC_", returnCode);
    call symputx("_lsafMsg_", message);

  run;

%mend lsaf_activateprocessflow;
