/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.workflow.task;

import com.sas.lsaf.core.Attribute;
import com.sas.lsaf.core.type.AttributeDefinition;
import com.sas.lsaf.core.type.Type;
import com.sas.lsaf.macro.common.SasObjectProperties;
import com.sas.lsaf.macro.common.SasObjectProperty;
import com.sas.lsaf.macro.common.utils.PropertyUtils;
import com.sas.lsaf.macro.common.utils.SasUtils;
import com.sas.lsaf.workflow.task.UserTask;
import java.io.Serializable;
import java.util.List;

public class UserTaskHelper {
    public static List<SasObjectProperty> toSasObjectProperties(UserTask task) {
        String STRING = AttributeDefinition.AttributeType.STRING.name();
        String DATE = AttributeDefinition.AttributeType.DATE.name();
        String LONG = AttributeDefinition.AttributeType.LONG.name();
        String tId = task.getId();
        SasObjectProperties p = new SasObjectProperties();
        p.addReadonlyRequiredProperty(tId, "type", STRING, (Serializable)task.getType());
        p.addReadonlyRequiredProperty(tId, "elementId", STRING, (Serializable)((Object)task.getElementId()));
        p.addEditableRequiredProperty(tId, "name", STRING, (Serializable)((Object)task.getName()));
        p.addEditableProperty(tId, "description", STRING, (Serializable)((Object)task.getDescription()));
        p.addReadonlyRequiredProperty(tId, "created", DATE, (Serializable)((Object)SasUtils.toSasString(task.getCreated())));
        p.addReadonlyRequiredProperty(tId, "processFlowId", STRING, (Serializable)((Object)task.getProcessFlowId()));
        p.addReadonlyRequiredProperty(tId, "processFlowStatus", STRING, (Serializable)task.getFlowStatus());
        p.addReadonlyProperty(tId, "dateStarted", DATE, (Serializable)((Object)SasUtils.toSasString(task.getStarted())));
        p.addReadonlyRequiredProperty(tId, "status", STRING, (Serializable)task.getTaskStatus());
        p.addEditableRequiredProperty(tId, "complexity", STRING, (Serializable)((Object)SasUtils.toSasString(task.getComplexity())));
        p.addEditableRequiredProperty(tId, "priority", STRING, (Serializable)((Object)SasUtils.toSasString(task.getPriority())));
        p.addEditableProperty(tId, "assigneeID", STRING, (Serializable)((Object)SasUtils.toSasString(task.getAssignee())));
        p.addReadonlyProperty(tId, "dateAssigned", DATE, (Serializable)((Object)SasUtils.toSasString(task.getAssigned())));
        p.addEditableProperty(tId, "dueDate", DATE, (Serializable)((Object)SasUtils.toSasDatetimeFormat(task.getDueDate())));
        p.addEditableProperty(tId, "actualHours", LONG, (Serializable)((Object)SasUtils.toSasString(task.getActualHours())));
        List attributes = task.getAttributes();
        if (attributes.size() > 0) {
            Type type = PropertyUtils.getTypeById(task.getTypeId());
            for (Attribute a : attributes) {
                AttributeDefinition aDef = type.getAttributeDefinitionById(a.getId());
                p.addExtendedAttribute(tId, a.getId(), aDef.getName(), aDef.getAttributeType().name(), (Serializable)((Object)SasUtils.toSasString(a.getValue())));
            }
        }
        return p.getProperties();
    }
}

