/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.workflow.task;

import com.sas.lsaf.macro.common.result.Result;
import com.sas.lsaf.macro.common.utils.SasUtils;
import com.sas.lsaf.workflow.task.NotificationTask;
import com.sas.lsaf.workflow.task.Task;
import com.sas.lsaf.workflow.task.UserTask;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class SasTasksResult
extends Result {
    private List<Task> tasks = new ArrayList<Task>();

    public void setTasks(Set<Task> tasks) {
        this.tasks = new ArrayList<Task>(tasks);
    }

    public List<Task> getTasks() {
        return this.tasks;
    }

    public Task getTask(double index) {
        return this.tasks.get((int)index);
    }

    public int getSize() {
        return this.tasks.size();
    }

    public String getTaskId(double index) {
        return this.getTask(index).getId();
    }

    public String getCreated(double index) {
        return SasUtils.toSasString(this.getTask(index).getCreated());
    }

    public String getDescription(double index) {
        return this.getTask(index).getDescription();
    }

    public String getElementId(double index) {
        return this.getTask(index).getElementId();
    }

    public String getElementName(double index) {
        return this.getTask(index).getName();
    }

    public String getElementType(double index) {
        return this.getTask(index).getType().name();
    }

    public String getProcessFlowId(double index) {
        return this.getTask(index).getProcessFlowId();
    }

    public String getFlowStatus(double index) {
        return this.getTask(index).getFlowStatus().name();
    }

    public String getStarted(double index) {
        return SasUtils.toSasString(this.getTask(index).getStarted());
    }

    public String getStartedSasFormat(double index) {
        return SasUtils.toSasDatetimeFormat(this.getTask(index).getStarted());
    }

    public String getTaskStatus(double index) {
        return this.getTask(index).getTaskStatus().name();
    }

    public String getAssignee(double index) {
        if (this.getTask(index) instanceof UserTask) {
            return SasUtils.toSasString(((UserTask)this.getTask(index)).getAssignee());
        }
        return "";
    }

    public String getDueDate(double index) {
        if (this.getTask(index) instanceof UserTask) {
            return SasUtils.toSasString(((UserTask)this.getTask(index)).getDueDate());
        }
        return "";
    }

    public String getDueDateSasFormat(double index) {
        if (this.getTask(index) instanceof UserTask) {
            return SasUtils.toSasDatetimeFormat(((UserTask)this.getTask(index)).getDueDate());
        }
        return "";
    }

    public String getPriority(double index) {
        Task t = this.getTask(index);
        if (this.getTask(index) instanceof UserTask) {
            return SasUtils.toSasString(((UserTask)t).getPriority());
        }
        if (this.getTask(index) instanceof NotificationTask) {
            return SasUtils.toSasString(((NotificationTask)t).getPriority());
        }
        return "";
    }

    public String getComplexity(double index) {
        if (this.getTask(index) instanceof UserTask) {
            return SasUtils.toSasString(((UserTask)this.getTask(index)).getComplexity());
        }
        return "";
    }
}

