/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.workflow.task;

import com.sas.lsaf.macro.common.result.Result;
import com.sas.lsaf.macro.common.utils.SasUtils;
import com.sas.lsaf.security.principal.Principal;
import com.sas.lsaf.workflow.task.UserTaskAssignment;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class SasTaskAssignmentHistoryResult
extends Result {
    private List<UserTaskAssignment> assignments = new ArrayList<UserTaskAssignment>();

    public void setAssignments(Set<UserTaskAssignment> assignments) {
        this.assignments.addAll(assignments);
    }

    public List<UserTaskAssignment> getAssignments() {
        return this.assignments;
    }

    public int getSize() {
        return this.assignments.size();
    }

    public UserTaskAssignment getUserTaskAssignment(double index) {
        return this.assignments.get((int)index);
    }

    public String getTaskId(double index) {
        return this.getUserTaskAssignment(index).getTaskId();
    }

    public String getElementId(double index) {
        return this.getUserTaskAssignment(index).getElementId();
    }

    public String getDateAssigned(double index) {
        return SasUtils.toSasString(this.getUserTaskAssignment(index).getDateAssigned());
    }

    public String getSasFormattedDateAssigned(double index) {
        return SasUtils.toSasDatetimeFormat(this.getUserTaskAssignment(index).getDateAssigned());
    }

    public String getAssignee(double index) {
        Principal p = this.getUserTaskAssignment(index).getAssignee();
        return p == null ? "<unassigned>" : p.getPrincipalId();
    }

    public String getAssigneeDisplayName(double index) {
        Principal p = this.getUserTaskAssignment(index).getAssignee();
        return p == null ? "" : SasUtils.toSasString(p.getPrincipalName());
    }

    public String getDateStarted(double index) {
        return SasUtils.toSasString(this.getUserTaskAssignment(index).getDateStarted());
    }

    public String getSasFormattedDateStarted(double index) {
        return SasUtils.toSasDatetimeFormat(this.getUserTaskAssignment(index).getDateStarted());
    }

    public float getActualHours(double index) {
        return this.getUserTaskAssignment(index).getActualHours();
    }
}

