/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.workflow.task;

import com.sas.lsaf.macro.common.utils.SasUtils;
import com.sas.lsaf.macro.workflow.task.CompletedTaskHelper;
import com.sas.lsaf.workflow.element.CompletedElement;
import java.util.Date;

public class SasCompletedElement {
    private String elementId;
    private String elementName;
    private String elementType;
    private String instanceId;
    private Date created;
    private Date completed;
    private String completedBy;
    private CompletedElement.TaskCompletedState completedState;
    private CompletedTaskHelper.RecordType recordType;
    private String id;
    private String name;
    private String value;

    public SasCompletedElement(String elementId, String elementName, String elementType, String instanceId, Date created, Date completed, String completedBy, CompletedElement.TaskCompletedState completedState, CompletedTaskHelper.RecordType recordType, String id, String name, String value) {
        this.elementId = elementId;
        this.elementName = elementName;
        this.elementType = elementType;
        this.instanceId = instanceId;
        this.created = created;
        this.completed = completed;
        this.completedBy = completedBy;
        this.completedState = completedState;
        this.recordType = recordType;
        this.id = id;
        this.name = name;
        this.value = value;
    }

    public String getElementId() {
        return this.elementId;
    }

    public String getElementName() {
        return this.elementName;
    }

    public String getElementType() {
        return this.elementType;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getCreated() {
        return SasUtils.toSasString(this.created);
    }

    public String getCreatedSasFormat() {
        return SasUtils.toSasDatetimeFormat(this.created);
    }

    public String getCompleted() {
        return SasUtils.toSasString(this.completed);
    }

    public String getCompletedSasFormat() {
        return SasUtils.toSasDatetimeFormat(this.completed);
    }

    public String getCompletedBy() {
        return this.completedBy;
    }

    public String getCompletedState() {
        return this.completedState.name();
    }

    public String getRecordType() {
        return this.recordType.name();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String toHeaderString() {
        StringBuffer sb = new StringBuffer();
        sb.append("elementId=" + this.elementId);
        sb.append(", elementType=" + this.elementType);
        sb.append(", elementName=" + this.elementName);
        sb.append(", instanceId=" + this.instanceId);
        sb.append(", created=" + String.valueOf(this.created));
        sb.append(", completed=" + String.valueOf(this.completed));
        sb.append(", completedBy=" + this.completedBy);
        sb.append(", completedState=" + String.valueOf(this.completedState));
        return sb.toString();
    }

    public String toDetailString() {
        StringBuffer sb = new StringBuffer();
        sb.append("recordType=" + String.valueOf((Object)this.recordType));
        sb.append(", id=" + this.id);
        sb.append(", name=" + this.name);
        sb.append(", value=" + this.value);
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("SasCompletedElement [");
        sb.append(this.toHeaderString());
        sb.append(", ");
        sb.append(this.toDetailString());
        return sb.toString();
    }
}

