/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.workflow.task;

import com.sas.lsaf.core.AbstractIdentifiable;
import com.sas.lsaf.macro.common.ExceptionHandler;
import com.sas.lsaf.macro.common.SasProperties;
import com.sas.lsaf.macro.common.SasProperty;
import com.sas.lsaf.macro.common.ServiceManagerFactory;
import com.sas.lsaf.macro.common.result.Result;
import com.sas.lsaf.macro.common.result.SasObjectPropertiesResult;
import com.sas.lsaf.macro.common.utils.PropertyUtils;
import com.sas.lsaf.macro.common.utils.SasUtils;
import com.sas.lsaf.macro.common.utils.validation.ValidationUtils;
import com.sas.lsaf.macro.security.PrincipalUtils;
import com.sas.lsaf.macro.security.SasPrincipalDescriptors;
import com.sas.lsaf.macro.security.SasPrincipalsResult;
import com.sas.lsaf.macro.workflow.SasDataPropertyResult;
import com.sas.lsaf.macro.workflow.SasProcessFlowElementNotFoundException;
import com.sas.lsaf.macro.workflow.processflow.ProcessFlowUtils;
import com.sas.lsaf.macro.workflow.task.CompletedTaskHelper;
import com.sas.lsaf.macro.workflow.task.SasCompletedElementResult;
import com.sas.lsaf.macro.workflow.task.SasProcessFlowCompletedElementsResult;
import com.sas.lsaf.macro.workflow.task.SasProcessFlowCurrentElementsResult;
import com.sas.lsaf.macro.workflow.task.SasTaskAssignmentHistoryResult;
import com.sas.lsaf.macro.workflow.task.SasTasksResult;
import com.sas.lsaf.macro.workflow.task.UserTaskHelper;
import com.sas.lsaf.workflow.element.CompletedElement;
import com.sas.lsaf.workflow.processflow.DataProperty;
import com.sas.lsaf.workflow.task.Task;
import com.sas.lsaf.workflow.task.TaskQuery;
import com.sas.lsaf.workflow.task.TaskSearchResults;
import com.sas.lsaf.workflow.task.TaskService;
import com.sas.lsaf.workflow.task.UserTask;
import com.sas.lsaf.workflow.task.UserTaskDetails;
import com.sas.lsaf.workflow.task.UserTaskUpdateInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ProcessFlowTaskService {
    private static Log LOG = LogFactory.getLog(ProcessFlowTaskService.class);
    private static ProcessFlowTaskService FOR_COVERAGE = new ProcessFlowTaskService();

    private ProcessFlowTaskService() {
    }

    private static TaskService doGetService() {
        return ServiceManagerFactory.getApiTaskService();
    }

    public static void getProcessCurrentElements(String contextPath, String pfName, SasProcessFlowCurrentElementsResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Get process flow active tasks for " + pfName + " in " + contextPath));
        }
        try {
            String flowId = ProcessFlowUtils.getProcessFlowId(contextPath, pfName);
            Set tasks = ProcessFlowTaskService.doGetService().getCurrentElementsByProcessFlow(flowId);
            result.setTasks(contextPath, pfName, tasks);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void getProcessCompletedElements(String contextPath, String pfName, SasProcessFlowCompletedElementsResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Get process flow completed tasks for " + pfName + " in " + contextPath));
        }
        try {
            String flowId = ProcessFlowUtils.getProcessFlowId(contextPath, pfName);
            Set tasks = ProcessFlowTaskService.doGetService().getCompletedElementsByProcessFlow(flowId);
            result.setTasks(contextPath, pfName, tasks);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void getProcessCompletedElementDetails(String contextPath, String pfName, String elementId, SasCompletedElementResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Get process flow completed tasks for " + pfName + " in " + contextPath));
        }
        try {
            String flowId = ProcessFlowUtils.getProcessFlowId(contextPath, pfName);
            Set elements = ProcessFlowTaskService.doGetService().getCompletedElementsByProcessFlow(flowId);
            ArrayList<CompletedElement> allInstances = new ArrayList<CompletedElement>();
            if (ValidationUtils.valueIsMissing((Serializable)((Object)elementId))) {
                allInstances.addAll(elements);
            } else {
                for (CompletedElement e : elements) {
                    if (!e.getElementId().equals(elementId)) continue;
                    allInstances.add(e);
                }
                if (allInstances.isEmpty()) {
                    throw new SasProcessFlowElementNotFoundException(elementId);
                }
            }
            result.setProperties(contextPath, pfName, CompletedTaskHelper.toSasCompletedElements(allInstances));
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static boolean getTasksByQuery(String status, String elementId, String elementName, String processFlowName, String contextPath, String assigneeType, String assignees, String fromDueDate, String toDueDate, String priority, String limit, SasTasksResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Get tasks by query.");
        }
        try {
            TaskQuery.AssigneeType at;
            TaskQuery query = new TaskQuery();
            query.setStatus((Task.TaskStatus)ValidationUtils.validateNotRequiredEnum(status, "Status", Task.TaskStatus.class, true));
            query.setElementId(ValidationUtils.toJavaString(elementId));
            query.setName(ValidationUtils.toJavaString(elementName));
            query.setProcessFlowName(ValidationUtils.toJavaString(processFlowName));
            if (!ValidationUtils.valueIsMissing((Serializable)((Object)contextPath))) {
                HashSet<String> contexts = new HashSet<String>();
                contexts.add(contextPath);
                query.setContextPaths(contexts);
            }
            query.setAssigneeType((at = (TaskQuery.AssigneeType)ValidationUtils.validateNotRequiredEnum(assigneeType, "Assignee type", TaskQuery.AssigneeType.class, true)) == null ? TaskQuery.AssigneeType.CURRENT_USER : at);
            if (!ValidationUtils.valueIsMissing((Serializable)((Object)assignees))) {
                query.setAssignees(new HashSet<String>(SasUtils.getListFromSasCommaDelimitedString(assignees)));
            }
            query.setFromDueDate(ValidationUtils.validateDateString("From date", fromDueDate));
            query.setToDueDate(ValidationUtils.validateDateString("To date", toDueDate));
            query.setPriority((Task.Priority)ValidationUtils.validateNotRequiredEnum(priority, "Priority", Task.Priority.class, true));
            if (!ValidationUtils.valueIsMissing((Serializable)((Object)limit))) {
                query.setLimit(ValidationUtils.validateIntegerValue("Limit", limit));
            }
            TaskSearchResults searchResults = ProcessFlowTaskService.doGetService().search(query);
            result.setTasks(searchResults.getTasks());
            result.init(0, "Success.");
            return searchResults.isLimitReached();
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return false;
        }
    }

    public static void claimTask(String taskId, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Claiming task " + taskId));
        }
        try {
            ValidationUtils.validateRequiredParameter(taskId, "Task id");
            ProcessFlowTaskService.doGetService().claimTask(taskId);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void assignTask(String taskId, String userId, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Assigning task " + taskId + " to " + userId));
        }
        try {
            ValidationUtils.validateRequiredParameter(taskId, "Task id");
            ProcessFlowTaskService.doGetService().assignTask(taskId, ValidationUtils.toJavaString(userId));
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void startTask(String taskId, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Starting task " + taskId));
        }
        try {
            ValidationUtils.validateRequiredParameter(taskId, "Task id");
            ProcessFlowTaskService.doGetService().startTask(taskId);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static String getUserTaskStatus(String taskId, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting status for task " + taskId));
        }
        try {
            ValidationUtils.validateRequiredParameter(taskId, "Task id");
            UserTask task = ProcessFlowTaskService.doGetService().getCurrentUserTask(taskId);
            result.init(0, "Success.");
            return task.getTaskStatus().name();
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
            return "";
        }
    }

    public static void getUserTaskProperties(String taskId, SasObjectPropertiesResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting properties for user  task " + taskId));
        }
        try {
            ValidationUtils.validateRequiredParameter(taskId, "Task id");
            UserTask task = ProcessFlowTaskService.doGetService().getCurrentUserTask(taskId);
            result.setProperties(UserTaskHelper.toSasObjectProperties(task));
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void updateUserTaskProperties(String taskId, SasProperties properties, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Updating properties for " + taskId));
        }
        try {
            ValidationUtils.validateRequiredParameter(taskId, "Task id");
            ValidationUtils.assertRequiredSasProperties(properties);
            TaskService srv = ProcessFlowTaskService.doGetService();
            UserTaskDetails task = srv.getUserTaskDetails(taskId);
            PropertyUtils.updateIdentifiablePropertiesByType((AbstractIdentifiable)task, task.getAttributes(), properties);
            srv.updateUserTask((UserTaskUpdateInfo)task);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void getUserTaskCompletionData(String taskId, SasDataPropertyResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting completion data for " + taskId));
        }
        try {
            ValidationUtils.validateRequiredParameter(taskId, "Task id");
            result.setDataProperties(ProcessFlowTaskService.doGetService().getUserTaskDetails(taskId).getCompletionProperties());
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void setUserTaskCompletionData(String taskId, SasProperties completionData, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Setting completion data for " + taskId));
        }
        try {
            ValidationUtils.validateRequiredParameter(taskId, "Task id");
            ValidationUtils.assertRequiredSasInputDataList("Completion data", completionData);
            TaskService srv = ProcessFlowTaskService.doGetService();
            UserTaskDetails task = srv.getUserTaskDetails(taskId);
            for (SasProperty sasProp : completionData.getList()) {
                String propName = sasProp.getName();
                ValidationUtils.validateRequiredParameter(propName, "Completion data id");
                for (DataProperty dataProp : task.getCompletionProperties()) {
                    if (!dataProp.getId().equals(propName)) continue;
                    dataProp.setValue(ValidationUtils.toJavaSerializable(propName, sasProp.getValue(), dataProp.getType().name()));
                }
            }
            srv.updateUserTask((UserTaskUpdateInfo)task);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void completeTask(String taskId, String actualHours, SasProperties completionData, String comment, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Completing task " + taskId));
        }
        try {
            ValidationUtils.validateRequiredParameter(taskId, "Task id");
            float actHours = ValidationUtils.validateRequiredFloat("Actual hours", actualHours);
            TaskService srv = ProcessFlowTaskService.doGetService();
            UserTaskDetails task = srv.getUserTaskDetails(taskId);
            HashSet<DataProperty> compData = null;
            if (completionData.getSize() > 0) {
                compData = new HashSet<DataProperty>();
                for (DataProperty dataProp : task.getCompletionProperties()) {
                    String dpName = dataProp.getId();
                    for (SasProperty sasProp : completionData.getList()) {
                        ValidationUtils.validateRequiredParameter(sasProp.getName(), "Completion data id");
                        if (!sasProp.getName().equals(dpName)) continue;
                        dataProp.setValue(ValidationUtils.toJavaSerializable(sasProp.getName(), sasProp.getValue(), dataProp.getType().name()));
                    }
                    compData.add(dataProp);
                }
            }
            srv.completeTask(taskId, actHours, compData, comment);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void getUserTaskAssignmentHistory(String taskId, SasTaskAssignmentHistoryResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting task history for " + taskId));
        }
        try {
            ValidationUtils.validateRequiredParameter(taskId, "Task id");
            result.setAssignments(ProcessFlowTaskService.doGetService().getUserTaskDetails(taskId).getTaskAssignmentHistory());
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void getUserTaskCandidates(String taskId, SasPrincipalsResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting candidates for task " + taskId));
        }
        try {
            ValidationUtils.validateRequiredParameter(taskId, "Task id");
            result.setPrincipals(ProcessFlowTaskService.doGetService().getUserTaskDetails(taskId).getCandidates());
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void updateUserTaskCandidates(String taskId, SasPrincipalDescriptors candidates, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Updating candidates for task " + taskId));
        }
        try {
            ValidationUtils.validateRequiredParameter(taskId, "Task id");
            ValidationUtils.assertRequiredSasInputDataList("Task candidates", candidates);
            TaskService srv = ProcessFlowTaskService.doGetService();
            UserTaskDetails task = srv.getUserTaskDetails(taskId);
            task.setCandidates(PrincipalUtils.convertSasPrincipalsToApiPrincipals("Candidate id", candidates));
            srv.updateUserTask((UserTaskUpdateInfo)task);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }

    public static void clearUserTaskCandidates(String taskId, Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Clearing all candidates for task " + taskId));
        }
        try {
            ValidationUtils.validateRequiredParameter(taskId, "Task id");
            TaskService srv = ProcessFlowTaskService.doGetService();
            UserTaskDetails task = srv.getUserTaskDetails(taskId);
            task.getCandidates().clear();
            srv.updateUserTask((UserTaskUpdateInfo)task);
            result.init(0, "Success.");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, result);
        }
    }
}

