/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.workflow.task;

import com.sas.lsaf.core.Attribute;
import com.sas.lsaf.core.type.AttributeDefinition;
import com.sas.lsaf.core.type.Type;
import com.sas.lsaf.execution.job.JobInputFile;
import com.sas.lsaf.execution.job.JobInputFolder;
import com.sas.lsaf.execution.job.ParameterValue;
import com.sas.lsaf.macro.common.utils.PropertyUtils;
import com.sas.lsaf.macro.common.utils.SasUtils;
import com.sas.lsaf.macro.workflow.ProcessFlowElementHelper;
import com.sas.lsaf.macro.workflow.task.SasCompletedElement;
import com.sas.lsaf.security.principal.Principal;
import com.sas.lsaf.workflow.element.CompletedElement;
import com.sas.lsaf.workflow.element.CompletedSignalEvent;
import com.sas.lsaf.workflow.processflow.DataProperty;
import com.sas.lsaf.workflow.task.CompletedJobTask;
import com.sas.lsaf.workflow.task.CompletedNotificationTask;
import com.sas.lsaf.workflow.task.CompletedTask;
import com.sas.lsaf.workflow.task.CompletedUserTask;
import com.sas.lsaf.workflow.task.CompletedUserTaskDetails;
import com.sas.lsaf.workflow.task.UserTaskAssignment;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class CompletedTaskHelper
extends ProcessFlowElementHelper {
    private static List<SasCompletedElement> elementProperties = new ArrayList<SasCompletedElement>();
    private static CompletedElement element;
    private static String elementId;
    private static String elementName;
    private static String elementType;
    private static String instanceId;
    private static Date created;
    private static Date completed;
    private static String completedBy;
    private static CompletedElement.TaskCompletedState completedState;
    private static RecordType recordType;

    private static void setCompletedElement(CompletedElement e) {
        element = e;
        elementId = e.getElementId();
        elementName = e.getName();
        elementType = e.getType().name();
        instanceId = e.getId();
        created = e.getCreated();
        completed = e.getCompleted();
        completedBy = e.getCompletedBy();
        completedState = e.getCompletedState();
        recordType = RecordType.PROPERTY;
    }

    private static void doAdd(String id, String name, String value) {
        elementProperties.add(new SasCompletedElement(elementId, elementName, elementType, instanceId, created, completed, completedBy, completedState, recordType, id, name, value));
    }

    private static void doAdd(String name, String value) {
        CompletedTaskHelper.doAdd("", name, value);
    }

    private static void doSetJobTaskProperties() {
        CompletedJobTask jt = (CompletedJobTask)element;
        recordType = RecordType.PROPERTY;
        CompletedTaskHelper.doAdd("completedStatus", jt.getCompletedStatus());
        CompletedTaskHelper.doAdd("runAsOwner", SasUtils.toSasString(jt.getRunAsOwner()));
        CompletedTaskHelper.doAdd("jobPath", SasUtils.toSasString(jt.getJobPath()));
        CompletedTaskHelper.doAdd("jobVersion", SasUtils.toSasString(jt.getJobVersion()));
        CompletedTaskHelper.doAdd("jobDetails", SasUtils.toSasString(jt.getJobDetails()));
        recordType = RecordType.PARAMETER;
        for (ParameterValue pv : jt.getParameterValues()) {
            String name = pv.getName();
            Serializable value = pv.getValue();
            CompletedTaskHelper.doAdd(name, CompletedTaskHelper.getParameterValue(value));
        }
    }

    private static void doSetNotificationTaskProperties() {
        CompletedNotificationTask nt = (CompletedNotificationTask)element;
        recordType = RecordType.PROPERTY;
        CompletedTaskHelper.doAdd("completedStatus", nt.getCompletedStatus());
        CompletedTaskHelper.doAdd("subject", nt.getSubject());
        CompletedTaskHelper.doAdd("message", nt.getMessage() == null ? "" : nt.getMessage().trim());
        CompletedTaskHelper.doAdd("priority", nt.getPriority().name());
        recordType = RecordType.RECIPIENT;
        Set recipts = nt.getRecipients();
        if (recipts != null) {
            for (Principal p : nt.getRecipients()) {
                CompletedTaskHelper.doAdd(p.getPrincipalName(), p.getPrincipalId());
            }
        }
    }

    private static void doSetUserTaskProperties() {
        CompletedUserTaskDetails ut = (CompletedUserTaskDetails)element;
        recordType = RecordType.PROPERTY;
        CompletedTaskHelper.doAdd("complexity", ut.getComplexity().name());
        CompletedTaskHelper.doAdd("priority", ut.getPriority().name());
        CompletedTaskHelper.doAdd("dueDate", SasUtils.toSasString(ut.getDueDate()));
        CompletedTaskHelper.doAdd("totalActualHours", SasUtils.toSasString(ut.getTotalActualHours()));
        CompletedTaskHelper.doAdd("completionComment", ut.getCompletionComment());
        recordType = RecordType.COMPLETIONDATA;
        for (DataProperty dp : ut.getCompletionProperties()) {
            CompletedTaskHelper.doAdd(dp.getId(), dp.getName(), SasUtils.toSasString(dp.getValue()));
        }
        recordType = RecordType.ASSIGNMENT;
        int counter = 0;
        for (UserTaskAssignment ta : ut.getTaskAssignmentHistory()) {
            String taId = String.format("%03d", ++counter) + "-" + ta.getId();
            CompletedTaskHelper.doAdd(taId, "dateAssigned", SasUtils.toSasString(ta.getDateAssigned()));
            Principal p = ta.getAssignee();
            String assignee = p == null ? "<unassigned>" : p.getPrincipalId();
            CompletedTaskHelper.doAdd(taId, "assignee", assignee);
            CompletedTaskHelper.doAdd(taId, "dateStarted", SasUtils.toSasString(ta.getDateStarted()));
            CompletedTaskHelper.doAdd(taId, "actualHours", SasUtils.toSasString(ta.getActualHours()));
        }
    }

    public static String getParameterValue(Serializable parmValue) {
        if (parmValue instanceof JobInputFile) {
            JobInputFile jFile = (JobInputFile)parmValue;
            return jFile.getPath() + " [" + jFile.getVersion() + "]";
        }
        if (parmValue instanceof JobInputFolder) {
            JobInputFolder jFolder = (JobInputFolder)parmValue;
            return jFolder.getPath() + " [" + jFolder.isIncludeSubfolders() + "]";
        }
        return SasUtils.toSasString(parmValue);
    }

    public static List<SasCompletedElement> toSasCompletedElements(List<CompletedElement> elements) {
        elementProperties = new ArrayList<SasCompletedElement>();
        for (CompletedElement ce : elements) {
            CompletedTaskHelper.setCompletedElement(ce);
            CompletedTaskHelper.doAdd("description", SasUtils.toSasString(ce.getDescription()));
            if (ce instanceof CompletedTask) {
                CompletedTask ct = (CompletedTask)element;
                List attributes = ct.getAttributes();
                if (attributes.size() > 0) {
                    recordType = RecordType.ATTRIBUTE;
                    Type type = PropertyUtils.getTypeById(ct.getTypeId());
                    for (Attribute a : attributes) {
                        AttributeDefinition aDef = type.getAttributeDefinitionById(a.getId());
                        CompletedTaskHelper.doAdd(a.getId(), aDef.getName(), SasUtils.toSasString(a.getValue()));
                    }
                }
                if (ct instanceof CompletedJobTask) {
                    CompletedTaskHelper.doSetJobTaskProperties();
                    continue;
                }
                if (ct instanceof CompletedNotificationTask) {
                    CompletedTaskHelper.doSetNotificationTaskProperties();
                    continue;
                }
                if (!(ct instanceof CompletedUserTask)) continue;
                CompletedTaskHelper.doSetUserTaskProperties();
                continue;
            }
            if (!(ce instanceof CompletedSignalEvent)) continue;
            CompletedSignalEvent cse = (CompletedSignalEvent)ce;
            CompletedTaskHelper.doAdd("signalName", SasUtils.toSasString(cse.getSignalName()));
            CompletedTaskHelper.doAdd("signaledBy", SasUtils.toSasString(cse.getSignaledBy()));
        }
        return elementProperties;
    }

    static {
        recordType = RecordType.PROPERTY;
    }

    public static enum RecordType {
        ATTRIBUTE,
        PROPERTY,
        RECIPIENT,
        ASSIGNMENT,
        COMPLETIONDATA,
        PARAMETER;

    }
}

