/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.workflow.setup;

import com.sas.lsaf.macro.common.utils.SasUtils;
import com.sas.lsaf.workflow.processflow.setup.TimerEventSetup;
import java.io.Serializable;
import java.util.Date;

public class SasProcessFlowTimerElement {
    private static int DEFAULT_DURATION_VALUE = -1;
    private String elementId;
    private String name;
    private String description;
    private String timerType;
    private String timerValue;
    private int years = DEFAULT_DURATION_VALUE;
    private int months = DEFAULT_DURATION_VALUE;
    private int days = DEFAULT_DURATION_VALUE;
    private int hours = DEFAULT_DURATION_VALUE;
    private int minutes = DEFAULT_DURATION_VALUE;
    private int seconds = DEFAULT_DURATION_VALUE;
    private static final String NUMBERS = "[0-9]";

    public SasProcessFlowTimerElement() {
    }

    public SasProcessFlowTimerElement(TimerEventSetup def) {
        this.elementId = def.getElementId();
        this.name = def.getName();
        this.description = def.getDescription();
        this.timerType = def.getTimerType().name();
        Serializable value = def.getTimerValue();
        if (this.timerType.equals(TimerEventSetup.TimerType.DURATION.name())) {
            this.timerValue = SasUtils.toSasString((String)((Object)value));
            this.doSetDurationValuesFromTimerValue(this.timerValue);
        } else {
            this.timerValue = SasUtils.toSasDatetimeFormat((Date)value);
        }
    }

    private void doSetDurationValuesFromTimerValue(String value) {
        String parseValue = value.substring(1);
        this.years = 0;
        this.months = 0;
        this.days = 0;
        this.hours = 0;
        this.minutes = 0;
        this.seconds = 0;
        boolean isTimeElement = false;
        Object holdNumbers = "";
        for (int indx = 0; indx < parseValue.length(); ++indx) {
            String currentChar = parseValue.substring(indx, indx + 1);
            if (currentChar.matches(NUMBERS)) {
                holdNumbers = (String)holdNumbers + currentChar;
                continue;
            }
            if (currentChar.toUpperCase().equals("T")) {
                isTimeElement = true;
                continue;
            }
            int intValue = Integer.parseInt((String)holdNumbers);
            switch (currentChar.toUpperCase()) {
                case "Y": {
                    this.years = intValue;
                    break;
                }
                case "M": {
                    if (isTimeElement) {
                        this.minutes = intValue;
                        break;
                    }
                    this.months = intValue;
                    break;
                }
                case "D": {
                    this.days = intValue;
                    break;
                }
                case "H": {
                    this.hours = intValue;
                    break;
                }
                case "S": {
                    this.seconds = intValue;
                    break;
                }
            }
            holdNumbers = "";
        }
    }

    private String getValidatedUnitString(int value, String field) {
        String label = field.substring(0, 1).toUpperCase();
        if (value > 0) {
            return Integer.toString(value) + label;
        }
        return "";
    }

    public String getId() {
        return this.elementId;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getTimerType() {
        return this.timerType;
    }

    public String getTimerValue() {
        return this.timerValue;
    }

    public int getYears() {
        return this.years;
    }

    public int getMonths() {
        return this.months;
    }

    public int getDays() {
        return this.days;
    }

    public int getHours() {
        return this.hours;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public String getDurationValueFromUnitValues() {
        String dateString = this.getValidatedUnitString(this.getYears(), "years") + this.getValidatedUnitString(this.getMonths(), "months") + this.getValidatedUnitString(this.getDays(), "days");
        String timeString = this.getValidatedUnitString(this.getHours(), "hours") + this.getValidatedUnitString(this.getMinutes(), "minutes") + this.getValidatedUnitString(this.getSeconds(), "seconds");
        if (timeString.length() > 0) {
            timeString = "T" + timeString;
        }
        String duration = ("P" + dateString + timeString).replaceAll("\\s", "").trim();
        return duration;
    }

    public void setTimerValues(String dateValue, double years, double months, double days, double hours, double minutes, double seconds) {
        this.timerValue = dateValue;
        this.years = (int)years;
        this.months = (int)months;
        this.days = (int)days;
        this.hours = (int)hours;
        this.minutes = (int)minutes;
        this.seconds = (int)seconds;
    }
}

