/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.macro.workflow.setup;

import com.sas.lsaf.macro.common.result.Result;
import com.sas.lsaf.macro.common.utils.SasUtils;
import com.sas.lsaf.workflow.processflow.setup.ElementSetup;
import com.sas.lsaf.workflow.processflow.setup.SignalEventSetup;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class SasProcessFlowSignalLocationsResult
extends Result {
    private String processFlowContext;
    private String processFlowName;
    private List<SasProcessFlowSignalLocation> locations = new ArrayList<SasProcessFlowSignalLocation>();

    public void setLocations(String pfContext, String pfName, List<SasProcessFlowSignalLocation> signalLocations) {
        this.processFlowContext = pfContext;
        this.processFlowName = pfName;
        this.locations = signalLocations;
    }

    public int getSize() {
        return this.locations.size();
    }

    public String getProcessFlowContext() {
        return this.processFlowContext;
    }

    public String getProcessFlowName() {
        return this.processFlowName;
    }

    public String getElementID(double index) {
        return this.locations.get((int)index).getElementID();
    }

    public String getSignalName(double index) {
        return this.locations.get((int)index).getSignalName();
    }

    public String getPath(double index) {
        return SasUtils.toSasString(this.locations.get((int)index).getPath());
    }

    public static List<SasProcessFlowSignalLocation> toSasSignalLocationsFromSignalElements(List<ElementSetup> defs) {
        ArrayList<SasProcessFlowSignalLocation> sasElementLocations = new ArrayList<SasProcessFlowSignalLocation>();
        for (ElementSetup ed : defs) {
            if (!(ed instanceof SignalEventSetup)) continue;
            SignalEventSetup se = (SignalEventSetup)ed;
            Set listFromElement = se.getLocations();
            for (String loc : listFromElement) {
                sasElementLocations.add(new SasProcessFlowSignalLocation(se.getElementId(), se.getSignalName(), loc));
            }
        }
        return sasElementLocations;
    }

    public static class SasProcessFlowSignalLocation {
        private String elementID;
        private String signalName;
        private String path;

        public SasProcessFlowSignalLocation(String elementID, String elementName, String path) {
            this.elementID = elementID;
            this.signalName = elementName;
            this.path = path;
        }

        public String getElementID() {
            return this.elementID;
        }

        public String getSignalName() {
            return this.signalName;
        }

        public String getPath() {
            return this.path;
        }
    }
}

